% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.MainFunction.R
\name{gradDescent.predictInput}
\alias{gradDescent.predictInput}
\title{the gradDescent input data prediction stage}
\usage{
gradDescent.predictInput(gradDescent.model, gradDescent.data, inputData,
  normalize = TRUE)
}
\arguments{
\item{gradDescent.model}{a object that created exclusively from
gradDescent.learn function}

\item{gradDescent.data}{a object that created exclusively from 
gradDescent.preprocessing function.}

\item{inputData}{a data.frame of input data to be predicted.
input variable must be match with the dataTrain (excluded 
outputData).}

\item{normalize}{a boolean value for normalize the data using 
normalization parameter in gradDescent.data. Default value
is TRUE, which means this function will normalize the input
input data before predict calculation.}
}
\description{
This is the another last of main function to predict the user-given input data.
Instead of predict the data test in gradDescent.data object, this function will
predict user-given input data. Same as previous predict function, the output 
will be prediction data that wrapped into a class without error rate value.
}
\examples{
##################################
## I. Predict Input data using gradient descent model
square_feet <- c(1400,1600,1700,1875,1100,1550,2350,2450,1425,1700)

price <- c(245,312,279,308,199,219,405,324,319,255)

house_price <- data.frame(square_feet, price)

## do the preprocessing stage
house_price.data <- gradDescent.preprocessing(
      house_price,
      normalizationMethod="variance"
   )

## do the model building stage
GD.model <- gradDescent.learn(
      house_price.data,
      methodType="GD" 
   )

## create input data
input_square <- c(1500, 999, 1111)
inputData <- data.frame(input_square)

## predict input data
GD.predict <- gradDescent.predictInput(
      GD.model,
      house_price.data,
      inputData,
      normalize=TRUE
   )

##view predicted value
print(GD.predict$predictionData)

}

