% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{datas}
\alias{datas}
\title{Data Set}
\usage{
datas(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
The data set associated with the GPPM.
}
\description{
Extracts the data set from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
myData <- datas(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{fitted.GPPM}},
  \code{\link{getIntern}}, \code{\link{logLik.GPPM}},
  \code{\link{maxnObs}}, \code{\link{meanf}},
  \code{\link{nObs}}, \code{\link{nPars}},
  \code{\link{nPers}}, \code{\link{nPreds}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
