% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.R
\name{lik}
\alias{lik}
\alias{lik_gaussian}
\alias{lik_bernoulli}
\alias{lik_binomial}
\alias{lik_betabinom}
\alias{lik_poisson}
\title{Initialize likelihood}
\usage{
lik_gaussian(sigma = 0.5, prior_sigma = prior_logunif())

lik_bernoulli(link = "logit")

lik_binomial(link = "logit")

lik_betabinom(link = "logit", phi = 1, prior_phi = prior_logunif())

lik_poisson(link = "log")
}
\arguments{
\item{sigma}{Initial value for the noise standard deviation.}

\item{prior_sigma}{Prior for hyperparameter \code{sigma}. See \code{\link{priors}}.}

\item{link}{Link function if the likelihood supports non-identity links. See Details for
information about possible links for each likelihood.}

\item{phi}{The over dispersion parameter for beta binomial likelihood.}

\item{prior_phi}{Prior for hyperparameter \code{phi}. See \code{\link{priors}}.}
}
\value{
The likelihood object.
}
\description{
Functions for initializing the likelihood (observation model) which can then be passed to \code{\link{gp_init}}.
}
\details{
The supported likelihoods are:
\describe{
 \item{\code{lik_gaussian}}{Gaussian likelihood. Has no links (uses identity link).}
 \item{\code{lik_bernoulli}}{Bernoulli likelihood. Possible links: 'logit' or 'probit'.}
 \item{\code{lik_binomial}}{Binomial likelihood. Possible links: 'logit' or 'probit'.}
 \item{\code{lik_betabinom}}{Beta binomial likelihood. Possible links: 'logit' or 'probit'.}
 \item{\code{lik_poisson}}{Poisson likelihood. Possible links: 'log'.}
}
}
\examples{

# Basic usage
cf <- cf_sexp()
lik <- lik_binomial()
gp <- gp_init(cf, lik)


}
