% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{timer_init}
\alias{timer_init}
\title{Create a timer object which will return \code{TRUE} when checked and the
given duration has elapsed.}
\usage{
timer_init(duration, reset_mode = "checked")
}
\arguments{
\item{duration}{timer duration in seconds}

\item{reset_mode}{one of 'checked' (default) or 'created' .  If 'checked', then
when the timer is reset the next alarm will be set to \code{duration}
seconds after \code{timer_check()} last returned \code{TRUE}.
If 'created', then the time is reset to the next increment of \code{N * duration}
after the timestamp when the timer was created}
}
\value{
a \code{timer} object to used with \code{timer_check()}
}
\description{
The timer will automatically reset any time it is checked (via \code{check_timer()})
\emph{and} it returns \code{TRUE}.
}
\examples{
# Run two timers in a tight 'while' loop
# The short timer should trigger every 0.1 seconds
# The long timer will trigger after 1 second
# Note that the timers will reset every time they trigger (after returning TRUE)
long_timer <- timer_init(1)
short_timer <- timer_init(0.1)
counter <- 0L
while(TRUE) {
  if (timer_check(long_timer)) {
    cat("\nLong  timer fired at count: ", counter, "\n")
    break;
  } 
  if (timer_check(short_timer)) {
    cat("Short timer fired at count: ", counter,  "\n")
  } 
  counter <- counter + 1L
}
}
