% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliabilty.R
\name{reliability}
\alias{reliability}
\alias{reliability.default}
\alias{reliability.PlackettLuce}
\alias{reliability.pltree}
\title{Reliability based on worth parameters}
\usage{
reliability(x, ...)

\method{reliability}{default}(x, y = NULL, ...)

\method{reliability}{PlackettLuce}(x, ref, ...)

\method{reliability}{pltree}(x, ref, ...)
}
\arguments{
\item{x}{a numeric vector, or an object of 
of class \code{PlackettLuce} or \code{pltree}}

\item{...}{additional arguments passed to methods}

\item{y}{numeric, the reference value}

\item{ref}{a character or integer for indexing the
element containing reference values in \var{x}}
}
\value{
the reliability based on the worth parameters
}
\description{
Measures the precision of estimated values, and
 the potential response to selection on those 
 estimated values
}
\examples{
# vector example
x <- c(9.5, 12, 12.3, 15)
y <- 11.2
reliability(x, y)
 
# PlackettLuce example
library("PlackettLuce") 

R <- matrix(c(1, 2, 4, 3,
              4, 1, 2, 3,
              2, 3, 1, 4,
              4, 2, 3, 1,
              2, 1, 4, 3,
              1, 4, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

mod <- PlackettLuce(R)

reliability(mod, ref = "apple")
}
