% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{gorpiper}
\alias{gorpiper}
\title{gorpipe-r}
\description{
R library for interfacing with Genuity Science services.
}
\section{gorpipe-r functions}{

The main function you'll be using is:
* \code{\link{get_gorpipe}} to establish a connection to your Genuity Science APIs, and
}

\examples{
\dontrun{
library(gorpiper)
# Go to your CSA instance of choice that runs the Query API, e.g.
# https://your-wxnc-instance
# Note the internal names of the projects you have access to
# go to and copy your api_key from: https://your-wxnc-instance/api-key-service/token
# Paste it into the variable below:

path <- "~/User/gorscripts<version>-dist/bin"

# Make connection object
gorpipe <- get_gorpipe(api_key, "your_project")

# Print the connection details
print(conn)

# Run a simple query

results <- gor_query("gor #dbsnp# | top 10000", conn)

print(results)
}
}
