% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_auth.R
\name{sheets_deauth}
\alias{sheets_deauth}
\title{Suspend authorization}
\usage{
sheets_deauth()
}
\description{
Put googlesheets4 into a de-authorized state. Instead of sending a token,
googlesheets4 will send an API key. This can be used to access public
resources for which no Google sign-in is required. This is handy for using
googlesheets4 in a non-interactive setting to make requests that do not
require a token. It will prevent the attempt to obtain a token
interactively in the browser. The user can configure their own API key
via \code{\link[=sheets_auth_configure]{sheets_auth_configure()}} and retrieve that key via
\code{\link[=sheets_api_key]{sheets_api_key()}}.
In the absence of a user-configured key, a built-in default key is used.
}
\examples{
if (interactive()) {
  sheets_deauth()
  sheets_user()

  # get metadata on the public 'deaths' spreadsheet
  sheets_get(sheets_example("deaths"))
}
}
\seealso{
Other auth functions: \code{\link{sheets_auth_configure}()},
  \code{\link{sheets_auth}()}
}
\concept{auth functions}
