% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_webapp.R
\name{gs_webapp_get_token}
\alias{gs_webapp_get_token}
\title{Exchange authorization code for an access token}
\usage{
gs_webapp_get_token(auth_code,
  client_id = getOption("googlesheets.webapp.client_id"),
  client_secret = getOption("googlesheets.webapp.client_secret"),
  redirect_uri = getOption("googlesheets.webapp.redirect_uri"))
}
\arguments{
\item{auth_code}{authorization code returned by Google that appears in URL}

\item{client_id}{client id obtained from Google Developers Console}

\item{client_secret}{client secret obtained from Google Developers Console}

\item{redirect_uri}{where the response is sent, should be one of the
redirect_uri values listed for the project in Google's Developer Console,
must match exactly as listed including any trailing '/'}
}
\description{
Exchange the authorization code in the URL returned by
\code{\link{gs_webapp_auth_url}} to get an access_token. This function plays
a role similar to \code{\link{gs_auth}}, but in a Shiny-based workflow: it
stores a token object in an internal environment, where it can be retrieved
for making calls to the Google Sheets and Drive APIs. Read the documentation
for \code{\link{gs_webapp_auth_url}} for more details on OAuth2 within Shiny.
}
\seealso{
\code{\link{gs_webapp_auth_url}}
}
