% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_inspect.R
\name{gs_inspect}
\alias{gs_inspect}
\title{Visual overview of populated cells}
\usage{
gs_inspect(x)
}
\arguments{
\item{x}{data.frame or tbl_df}
}
\value{
a ggplot object
}
\description{
\emph{This function is still experimental. Expect it to change! Or
disappear?} This function plots a data.frame and gives a sense of what sort
of data is where (e.g. character vs. numeric vs factor). Empty cells (ie.
\code{NA}'s) are also indicated. The purpose is to get oriented to sheets
that contain more than one data rectangle. Right now, due to the tabular,
data-frame nature of the input, we aren't really conveying when disparate
data types appear in a column. That might be something to work on in a future
version, if this proves useful. That would require working with cell-by-cell
data, i.e. from the cell feed.
}
\examples{
\dontrun{
gs_inspect(iris)

# data recorded from a game of ultimate frisbee
ulti_key <- "1223dpf3vnjZUYUnCM8rBSig3JlGrAu1Qu6VmPvdEn4M"
ulti_ss <- ulti_key \%>\% gs_key()
ulti_dat <- ulti_ss \%>\% gs_read()
gs_inspect(ulti_dat)

# totally synthetic example
x <- suppressWarnings(matrix(0:1, 21, 21))
x[sample(21^2, 10)] <- NA
x <- as.data.frame(x)
some_columns <- seq(from = 1, to = 21, by = 3)
x[some_columns] <- lapply(x[some_columns], as.numeric)
gs_inspect(x)
}
}

