% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_ws.R
\name{gs_ws_resize}
\alias{gs_ws_resize}
\title{Resize a worksheet}
\usage{
gs_ws_resize(ss, ws = 1, row_extent = NULL, col_extent = NULL,
  verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{row_extent}{integer for new row extent; if unspecified, the Google
Sheets default is 1000}

\item{col_extent}{integer for new column extent; if unspecified, the Google
Sheets default is 26}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Set the number of rows and columns of a worksheet. We use this function
internally during cell updates, if the data would exceed the current
worksheet extent, and to trim worksheet down to fit the data exactly. Is it
possible a user might want to use this directly?
}
\note{
Setting rows and columns to less than the current worksheet dimensions
  will delete contents without warning!
}
\examples{
\dontrun{
yo <- gs_new("yo")
yo <- gs_edit_cells(yo, input = head(iris), trim = TRUE)
gs_read_csv(yo)
yo <- gs_ws_resize(yo, ws = "Sheet1", row_extent = 5, col_extent = 4)
gs_read_csv(yo)
yo <- gs_ws_resize(yo, ws = 1, row_extent = 3, col_extent = 3)
gs_read_csv(yo)
yo <- gs_ws_resize(yo, row_extent = 2, col_extent = 2)
gs_read_csv(yo)
gs_delete(yo)
}

}
\keyword{internal}

