% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gs_read_csv.R
\name{gs_read_csv}
\alias{gs_read_csv}
\title{Read data via the \code{exportcsv} link}
\usage{
gs_read_csv(ss, ws = 1, ..., verbose = TRUE)
}
\arguments{
\item{ss}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{ws}{positive integer or character string specifying index or title,
respectively, of the worksheet}

\item{...}{Further arguments to be passed to the csv parser. This is
currently \code{\link{read.csv}}, but expect a switch to
\code{readr::read_csv} in the not-too-distant future! Note that by default
\code{\link{read.csv}} is called with \code{stringsAsFactors = FALSE}.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a tbl_df
}
\description{
This function reads all data from a worksheet and returns it as a
\code{tbl_df} or \code{data.frame}. Don't be spooked by the "csv" thing --
the data is NOT actually written to file during this process. Data is read
from the "maximal data rectangle", i.e. the rectangle spanned by the maximal
row and column extent of the data. Empty cells within this rectangle will be
assigned NA. This is the fastest method of data consumption, so use it as
long as you can tolerate the lack of control re: which cells are being read.
}
\details{
How does this compare to consumption via the list feed, implemented by
\code{\link{gs_read_listfeed}}? First, \code{gs_read_csv} is much, much
faster. Second, the first row, potentially containing column or variable
names, is NOT transformed/mangled, as it is via the list feed. Finally,
consumption via the \code{exportcsv} link is more tolerant of data that does
not form a perfect, neat rectangle, e.g. the read does NOT stop upon
encountering an empty row.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
oceania_csv <- gs_read_csv(gap_ss, ws = "Oceania")
str(oceania_csv)
oceania_csv
}
}
\seealso{
Other data.consumption.functions: \code{\link{gs_read_cellfeed}};
  \code{\link{gs_read_listfeed}}; \code{\link{gs_read}};
  \code{\link{gs_reshape_cellfeed}};
  \code{\link{gs_simplify_cellfeed}}
}

