% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{gtm_folders_move}
\alias{gtm_folders_move}
\title{Move entities to a new folder}
\usage{
gtm_folders_move(
  account_id,
  container_id,
  workspace_id,
  folder_id,
  tags = NULL,
  triggers = NULL,
  variables = NULL
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{folder_id}{Folder Id}

\item{tags}{The tags to be moved to the folder. This can either be an individual tag Id or a list of tag Ids}

\item{triggers}{The triggers to be moved to the folder. This can either be an individual trigger Id or a list of trigger Ids}

\item{variables}{The variables to be moved to the folder. This can either be an individual variable Id or a list of variable Ids}
}
\description{
This moves entities to a new folder.
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 3
folderId <- 1
tags = 12


gtm_folders_move(accountId, containerId, workspaceId, folderId, tags = tags)

triggers = c(1,2,3)
tags = c(4,5,6)

gtm_folders_move(accountId, containerId, workspaceId, folderId, tags = tags)

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/folders/move_entities_to_folder}

Other folder functions: 
\code{\link{gtm_folders_create}()},
\code{\link{gtm_folders_delete}()},
\code{\link{gtm_folders_entities}()},
\code{\link{gtm_folders_get}()},
\code{\link{gtm_folders_list}()},
\code{\link{gtm_folders_revert}()},
\code{\link{gtm_folders_update}()}
}
\concept{folder functions}
