% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{gtm_folders_create}
\alias{gtm_folders_create}
\title{Creates a GTM Folder}
\usage{
gtm_folders_create(account_id, container_id, workspace_id, name, notes = NULL)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{name}{Folder display name}

\item{notes}{User notes on how to apply this folder in the container.}
}
\description{
This creates a new folder in the specified workspaces
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 3
folderName <- "Analytics Tags"
folderNotes <- "All our website's Google Analytics Tags"

folder <- gtm_folders_create(accountId, containerId, workspaceId, folderName, folderNotes)

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/folders/get}

Other folder functions: 
\code{\link{gtm_folders_delete}()},
\code{\link{gtm_folders_entities}()},
\code{\link{gtm_folders_get}()},
\code{\link{gtm_folders_list}()},
\code{\link{gtm_folders_move}()},
\code{\link{gtm_folders_revert}()},
\code{\link{gtm_folders_update}()}
}
\concept{folder functions}
