% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Encode.R
\name{encodeCoordinates}
\alias{encodeCoordinates}
\title{Encode coordinates}
\usage{
encodeCoordinates(lon, lat)
}
\arguments{
\item{lon}{vector of longitudes}

\item{lat}{vector of latitudes}
}
\description{
Encodes a vector of lon & lat coordinates
}
\examples{
\dontrun{

## Grouping by polygons and lines
df <- data.frame(polygonId = c(1,1,1,1,1,1,1,1,2,2,2,2),
  lineId = c(1,1,1,1,2,2,2,2,1,1,1,1),
  lon = c(-80.190, -66.118, -64.757, -80.190,  -70.579, -67.514, -66.668, -70.579, 
  -70, -49, -51, -70),
  lat = c(26.774, 18.466, 32.321, 26.774, 28.745, 29.570, 27.339, 28.745, 
  22, 23, 22, 22))


## using dplyr groups   

library(dplyr)
df \%>\%
  group_by(polygonId, lineId) \%>\% 
  summarise(polyline = encodeCoordinates(lon, lat))
  
## using data.table
library(data.table)
setDT(df)
df[, encodeCoordinates(lon = lon, lat = lat), by = .(polygonId, lineId)]


}

}
\seealso{
\link{encode}
}
