% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_pkgdown}
\alias{cr_buildstep_pkgdown}
\title{Create buildsteps for deploying an R pkgdown website to GitHub}
\usage{
cr_buildstep_pkgdown(
  github_repo,
  git_email,
  keyring = "my-keyring",
  key = "github-key",
  env = NULL,
  cipher = "id_rsa.enc",
  build_image = "gcr.io/gcer-public/packagetools:master"
)
}
\arguments{
\item{github_repo}{The GitHub repo to deploy pkgdown website from and to.}

\item{git_email}{The email the git commands will be identifying as}

\item{keyring}{The Key Management Store keyring containing the git ssh key}

\item{key}{The Key Management Store key containing the gitssh key}

\item{env}{A character vector of env arguments to set for all steps}

\item{cipher}{The filename of the encrypted git ssh key that has been checked into the repository}

\item{build_image}{A docker image with \code{pkgdown} installed}
}
\description{
Create buildsteps for deploying an R pkgdown website to GitHub
}
\details{
Its convenient to set some of the above via \link{Build} macros, such as \code{github_repo=$_GITHUB_REPO} and \code{git_email=$_BUILD_EMAIL} in the Build Trigger web UI
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
# github repo set via build trigger macro _GITHUB_REPO
cr_buildstep_pkgdown("$_GITHUB_REPO",
                     "cloudbuild@google.com")

# example including environment arguments for pkgdown build step
steps <- cr_buildstep_pkgdown("$_GITHUB_REPO",
                     "cloudbuild@google.com",
                     env = c("MYVAR=$_MY_VAR", "PROJECT=$PROJECT_ID"))
build_yaml <- cr_build_yaml(steps = steps)
my_source <- cr_build_source(RepoSource("my_repo", branch="master"))
build <- cr_build_make(build_yaml, source = my_source)
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
