\name{Gosum-class}

\encoding{latin1}

\docType{class}

\alias{Gosum-class}
\alias{show,Gosum-method}

\title{Class "Gosum": Summary object of GO-GARCH model}

\description{The formal summary class of \code{GoGARCH} objects or objects that
  extend this class.}

\section{Objects from the Class}{
  Objects can be created by calls of the form \code{new("Gosum", ...)}
  or are set by the summary-method. 
}

\section{Slots}{
	 \describe{
    \item{\code{name}:}{\code{character}: the name of the original data object.}
    \item{\code{method}:}{\code{character}: the estimation method.}
    \item{\code{model}:}{\code{formula}: The GARCH model formula for the
	 component GARCH models.}
    \item{\code{garchc}:}{\code{list}: The elements are \code{matcoef} matrices
	 generated by \code{garchFit} for the components.}
    \item{\code{Zinv}:}{\code{matrix}: The inverse of the linear map \eqn{X = Y
	 Z}.}
  }
}

\section{Methods}{
  \describe{
    \item{show}{show-method for objects of class \code{Gosum}.}
  }
}

\author{
  Bernhard Pfaff
}

\seealso{
  \code{\linkS4class{GoGARCH}}, \code{\linkS4class{Goestml}} 
}

\keyword{classes}
