% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_genesets_hypergeometric.R
\name{test_genesets_hypergeometric}
\alias{test_genesets_hypergeometric}
\title{Geneset ORA using hypergeometric test}
\usage{
test_genesets_hypergeometric(genesets, genelist, require_nsignif = 1L)
}
\arguments{
\item{genesets}{tibble with genesets, must contain columns 'id', 'ngenes' and 'ngenes_signif'}

\item{genelist}{tibble with genes, must contain column 'signif'. The number of rows in this table (where signif is not NA)
is assumed to be the total number of tested genes, the number of rows where signif==TRUE is assumed the total number of significant genes.}

\item{require_nsignif}{minimum number of 'signif genes' that overlap with a geneset; \code{NA} pvalues are returned for genesets with \code{ngenes_signif <= require_nsignif}.
This function 'prefilters' genesets, so beware that this will influence downstream multiple testing correction. Default is 1}
}
\value{
input \code{genesets} table with results in the "pvalue" column
}
\description{
In most cases, it's more convenient to call the more generic \code{test_genesets} function which also deals with multiple-testing correction (per geneset source)

It is assumed that the \code{genesets} and \code{genelist} parameters are in sync, i.e. \code{genesets} provided
here is the result of the \code{filter_genesets()} function (using the same \code{genelist} table)

Only genesets with at least 1 significant gene are subjected to statistical testing (e.g. NA is returned for genesets without significant genes)
}
\seealso{
\code{test_genesets}
}
