% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{read_imu}
\alias{read_imu}
\title{Read an IMU Binary File into R}
\usage{
read_imu(file_path, imu_type)
}
\arguments{
\item{file_path}{A \code{string} that contains the full file path.}

\item{imu_type}{A \code{string} that contains a supported IMU type given below.}
}
\value{
A matrix with dimensions N x 7, where the columns represent:
\describe{
\item{Col 0}{Time}
\item{Col 1}{Gyro 1}
\item{Col 2}{Gyro 2}
\item{Col 3}{Gyro 3}
\item{Col 4}{Accel 1}
\item{Col 5}{Accel 2}
\item{Col 6}{Accel 3}
}
}
\description{
The function will take a file location in addition to the type of sensor it
came from and read the data into R.
}
\details{
Currently supports the following IMUs:
\itemize{
\item IMAR
\item LN200
\item LN200IG
\item IXSEA
\item NAVCHIP_INT
\item NAVCHIP_FLT
}

We hope to soon be able to support delimited files.
}
\examples{
\dontrun{
read_imu(file_path = "F:/Desktop/short_test_data.imu", imu_type = "IXSEA")
}
}
\references{
Thanks goes to Philipp Clausen of Labo TOPO, EPFL, Switzerland, topo.epfl.ch, Tel:+41(0)21 693 27 55
for providing a matlab function that reads in IMUs.
The function below is a heavily modified port of MATLAB code into Armadillo/C++.
}
\keyword{internal}

