% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{plot.gts}
\alias{plot.gts}
\title{Plot Time Series Data}
\usage{
\method{plot}{gts}(x, to.unit = NULL, background = "white",
  line.type = "solid", line.color = "#003C7D", point.size = 0,
  point.shape = 20, title = NULL, title.size = 15, axis.label.size = 13,
  axis.tick.size = 11, axis.x.label = NULL, axis.y.label = NULL, ...)
}
\arguments{
\item{x}{A \code{gts} object}

\item{to.unit}{A \code{string} indicating the unit which the data is converted to. The supported units are "ns"(nanosecond), "ms"(millisecond), "sec", "min", "hour", "day", "month", and "year".}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{line.type}{A \code{string} that indicates the type of lines.}

\item{line.color}{A \code{string} that indicates the color of lines.}

\item{point.size}{An \code{integer} that indicates the size of points on lines.}

\item{point.shape}{An \code{integer} that indicates the shape of points on lines.}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}

\item{...}{other arguments passed to specific methods}
}
\value{
A ggplot2 panel containing the graph of time series.
}
\description{
This function is implemented with ggplot2.
}
\examples{
x = gen.gts(WN(sigma2=1), 50, unit = 'sec', freq = 1)
plot(x)
plot(x, to.unit = 'ns', line.type = 'dashed', line.color = 'black', point.size = 2)
}
\author{
Wenchao
}

