% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_qn}
\alias{deriv_qn}
\title{Analytic D matrix quantisation noise process}
\usage{
deriv_qn(tau)
}
\arguments{
\item{tau}{A \code{vec} that contains the scales to be processed (e.g. 2^(1:J))}
}
\value{
A \code{matrix} with the first column containing the partial derivative with respect to \eqn{Q _0^2}{Q[0]^2}.
}
\description{
Analytic D matrix quantisation noise process
}
\details{
The haar wavelet variance is given as \eqn{{\nu ^2}\left( \tau  \right) = \frac{{3Q_0^2}}{{2{\tau ^2}}}}{nu^2(tau) = 3*Q[0]^2 / 2*tau^2}.
Taking the derivative with respect to \eqn{Q _0^2}{Q[0]^2} yields: \deqn{\frac{\partial }{{\partial Q_0^2}}{\nu ^2}\left( \tau  \right) = \frac{3}{{2{\tau ^2}}}}{3/(2*tau^2)}.
The second derivative derivative with respect to \eqn{Q _0^2}{Q[0]^2} is then: \deqn{\frac{{{\partial ^2}}}{{\partial Q_0^4}}{\nu ^2}\left( \tau  \right) = 0}{0}.
}
\examples{
deriv_qn(2^(1:5))
}
\author{
JJB
}

