% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modwt.R
\name{modwt}
\alias{modwt}
\title{Maximum Overlap Discrete Wavelet Transform}
\usage{
modwt(x)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1.}
}
\value{
y A \code{field<vec>} that contains the wavelet coefficients for each decomposition level
}
\description{
Calculation of the coefficients for the discrete wavelet transformation
}
\details{
Performs a level \eqn{J} decomposition of the time series using the pyramid algorithm.
\eqn{J} is determined by \eqn{floor\left(log_2 \left(length\left(x\right)\right)\right)}{floor(log2(length(x)))}
This function was designed to minimize the amount of work a user performs. 
If you need more complex computations, see \code{\link{modwt_cpp}}.
}
\examples{
set.seed(999)
x=rnorm(100)
modwt(x)
}
\author{
JJB
}

