% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{avar_to_cpp}
\alias{avar_to_cpp}
\title{Compute Tau-Overlap Allan Variance}
\usage{
avar_to_cpp(x)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1.}
}
\value{
av A \code{matrix} that contains:
\itemize{
 \item{Col 1}{The size of the cluster}
 \item{Col 2}{The Allan variance}
 \item{Col 3}{The error associated with the variance estimation.}
}
}
\description{
Computation of Tau-Overlap Allan Variance
}
\details{
Given \eqn{N} equally spaced samples with averaging time \eqn{\tau = n\tau _0}{tau = n*tau_0},
where \eqn{n} is an integer such that \eqn{ 1 \le n \le \frac{N}{2}}{1<= n <= N/2}.
Therefore, \eqn{n} is able to be selected from \eqn{\left\{ {n|n < \left\lfloor {{{\log }_2}\left( N \right)} \right\rfloor } \right\}}{{n|n< floor(log2(N))}}
Then, a sampling of \eqn{m = \left\lfloor {\frac{{N - 1}}{n}} \right\rfloor  - 1} samples exist. 
The tau-overlap estimator is given by:

where \eqn{ {{\bar y}_t}\left( \tau  \right) = \frac{1}{\tau }\sum\limits_{i = 0}^{\tau  - 1} {{{\bar y}_{t - i}}} }.
}
\examples{
set.seed(999)
# Simulate white noise (P 1) with sigma^2 = 4
N = 100000
white.noise = rnorm(N, 0, 2)
#plot(white.noise,ylab="Simulated white noise process",xlab="Time",type="o")
#Simulate random walk (P 4)
random.walk = cumsum(0.1*rnorm(N, 0, 2))
combined.ts = white.noise+random.walk
av_mat = avar_to_cpp(combined.ts)
}
\author{
JJB
}
\references{
Long-Memory Processes, the Allan Variance and Wavelets, D. B. Percival and P. Guttorp
}

