% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{autoplot.wvarComp}
\alias{autoplot.wvarComp}
\title{Detail Implementation to Compare Wavelet Variances}
\usage{
\method{autoplot}{wvarComp}(object, split = TRUE, CI = TRUE,
  background = "white", transparence = 0.1, line.color = NULL,
  CI.color = NULL, line.type = NULL, point.size = NULL,
  point.shape = NULL, title = "Haar Wavelet Variance Representation",
  title.size = 15, axis.label.size = 13, axis.tick.size = 11,
  axis.x.label = expression(paste("Scale ", tau)),
  axis.y.label = expression(paste("Wavelet Variance ", nu)),
  facet.label.size = 13, legend.label = NULL, legend.title = "",
  legend.key.size = 1.3, legend.title.size = 13, legend.text.size = 13,
  nrow = 1, ...)
}
\arguments{
\item{object}{A \code{data frame} that contains data in order to plot}

\item{split}{A \code{boolean} that indicates whether the graphs should be separate (TRUE) or graphed ontop of each other (FALSE)}

\item{CI}{A \code{boolean} that indicates whether the confidence interval should be plotted.}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{transparence}{A \code{double} that ranges from 0 to 1 that controls the transparency of the graph}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of lines. If not \code{NULL}, length of vector must equal to the number of \code{wvar} objects that are passed in.}

\item{CI.color}{A \code{vector} of \code{string} that indicates the color of confidence interval. If not \code{NULL}, length of vector must equal to the number of \code{wvar} objects that are passed in.}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of lines for wavelet variance and the edge of confidence interval, respectively. Length of vector must equal to 2.}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of point}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of point}

\item{title}{A \code{string} that indicates the title of the graph}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark}

\item{axis.x.label}{A \code{string} that indicates the label on x axis}

\item{axis.y.label}{A \code{string} that indicates the label on y axis}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label}

\item{legend.label}{A \code{vector} of \code{string} that indicates the labels on legend. If not \code{NULL}, length of vector must equal to the number of \code{wvar} objects that are passed in.}

\item{legend.title}{A \code{string} that indicates the title of legend}

\item{legend.key.size}{A \code{double} that indicates the size of key (in centermeters) on legend}

\item{legend.title.size}{An \code{integer} that indicates the size of title on legend.}

\item{legend.text.size}{An \code{integer} that indicates the size of key label on legend}

\item{nrow}{An \code{integer} that indicates number of rows}

\item{...}{Additional parameters}
}
\description{
Compare the estimates given by the classical and robust methods of calculating the wavelet variance.
}
\author{
JJB, Wenchao
}
\seealso{
\code{\link{compare.wvar}}
}
\keyword{internal}

