#' @describeIn GSMVAR Log-likelihood method
#' @inheritParams plot.gsmvar
#' @param object object of class \code{'gsmvar'} generated by \code{fitGSMVAR} or \code{GSMVAR}.
#' @export
logLik.gsmvar <- function(object, ...) object$loglik


#' @describeIn GSMVAR residuals method to extract multivariate quantile residuals
#' @inheritParams logLik.gsmvar
#' @export
residuals.gsmvar <- function(object, ...) {
  res <- object$quantile_residuals
  colnames(res) <- colnames(object$data)
  res
}


#' @describeIn GSMVAR summary method
#' @inheritParams logLik.gsmvar
#' @inheritParams print.gsmvar
#' @export
summary.gsmvar <- function(object, ..., digits=2) {
  gsmvar <- object
  structure(list(gsmvar=gsmvar,
                 abs_boldA_eigens=get_boldA_eigens(gsmvar),
                 omega_eigens=get_omega_eigens(gsmvar),
                 regime_means=get_regime_means(gsmvar),
                 digits=digits),
            class="gsmvarsum")
}
