% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaldAndLR.R, R/printMethods.R
\name{Wald_test}
\alias{Wald_test}
\alias{print.wald}
\title{Perform Wald test for a GMVAR or SGMVAR model}
\usage{
Wald_test(gmvar, A, c, h = 6e-06)

\method{print}{wald}(x, ..., digits = 4)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{A}{a size \eqn{(k x n_params)} matrix with full row rank specifying part of the null hypothesis
where \eqn{n_params} is the number of parameters in the (unconstrained) model.
See details for more information.}

\item{c}{a length \eqn{k} vector specifying part of the null hypothesis. See details for more information.}

\item{h}{difference used to approximate the derivatives.}

\item{x}{object of class \code{'wald'} generated by the function \code{Wald_test}.}

\item{...}{other arguments passed to \code{fn}}

\item{digits}{how many significant digits to print?}
}
\value{
Returns an object of class \eqn{'wald'} containing the test statistic and the related p-value.
}
\description{
\code{Wald_test} performs a Wald test for a GMVAR or SGMVAR model
}
\details{
Denoting the true parameter value by \eqn{\theta_{0}}, we test the null hypothesis \eqn{A\theta_{0}=c}.
  Under the null, the test statistic is asymptotically \eqn{\chi^2}-distributed with \eqn{k}
  (\code{=nrow(A)}) degrees of freedom. The parameter \eqn{\theta_{0}} is assumed to have the same form as in
  the model supplied in the argument \code{gmvar} and it is presented in the documentation of the argument
  \code{params} in the function \code{GMVAR} (see \code{?GMVAR}).

  Finally, note that this function does \strong{not} check whether the specified constraints are feasible (e.g. whether
  the implied constrained model would be stationary or have positive definite error term covariance matrices).
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: print method
}}

\examples{
\donttest{
 # Load the data
 data(eurusd, package="gmvarkit")
 data <- cbind(10*eurusd[,1], 100*eurusd[,2])
 colnames(data) <- colnames(eurusd)

 # Structural GMVAR(2, 2), d=2 model identified with sign-constraints:
 W_222 <- matrix(c(1, NA, -1, 1), nrow=2, byrow=FALSE)
 fit222s <- fitGMVAR(data, p=2, M=2, structural_pars=list(W=W_222),
                     ncalls=1, seeds=1)
 fit222s

 # Test whether the lambda parameters (of the second regime) are identical:
 # fit222s has parameter vector of length 27 with the lambda parameters
 # in elements 25 and 26.
 A <- matrix(c(rep(0, times=24), 1, -1, 0), nrow=1, ncol=27)
 c <- 0
 Wald_test(fit222s, A, c)

 # Test whether the off-diagonal elements of the first regime's first
 # AR coefficient matrix (A_11) are both zero:
 # fit222s has parameter vector of length 27 and the off-diagonal elements
 # of the 1st regime's 1st AR coefficient matrix are in the elements 6 and 7.
 A <- rbind(c(rep(0, times=5), 1, rep(0, times=21)),
            c(rep(0, times=6), 1, rep(0, times=20)))
 c <- c(0, 0)
 Wald_test(fit222s, A, c)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
     paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{LR_test}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{diagnostic_plot}},
 \code{\link{profile_logliks}}, \code{\link{quantile_residual_tests}}, \code{\link{cond_moment_plot}}
}
