% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_nodes.R
\name{rename_nodes}
\alias{rename_nodes}
\title{Rename nodes of a Gaussian mixture graphical model}
\usage{
rename_nodes(gmgm, nodes, names)
}
\arguments{
\item{gmgm}{An object of class \code{gmbn} or \code{gmdbn}.}

\item{nodes}{A character vector containing the renamed nodes.}

\item{names}{A character vector containing the respective new names of the
nodes.}
}
\value{
The \code{gmbn} or \code{gmdbn} object after renaming the nodes.
}
\description{
This function renames nodes of a Gaussian mixture graphical model. If this
model is a dynamic Bayesian network, the nodes are renamed for each of its
transition models.
}
\examples{
data(gmbn_body)
gmbn_1 <- rename_nodes(gmbn_body, c("FAT", "GLYCO"),
                       c("BODY_FAT", "GLYCOHEMOGLOBIN"))

data(gmdbn_air)
gmdbn_1 <- rename_nodes(gmdbn_air, "TEMP", "TEMPERATURE")

}
\seealso{
\code{\link{add_arcs}}, \code{\link{add_nodes}},
\code{\link{remove_arcs}}, \code{\link{remove_nodes}}
}
