% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{show}
\alias{show}
\alias{show.Music}
\title{Show Object}
\usage{
show(x, to)

\method{show}{Music}(x, to = NULL)
}
\arguments{
\item{x}{An object.}

\item{to}{Optional. A character vector which contains "score", "audio" or
both, which indicates whether to show the object as musical score or
audio file. The default value is "score".}
}
\value{
Invisible \code{NULL}.

The generated musical score or audio file is
\enumerate{
\item showed in Viewer panel if \code{show} is called in RStudio,
\item included in generated HTML file if called in R Markdown document,
\item showed in output cell if called in R Jupyter Notebook, and
\item showed in user's browser if called in a normal R console.
}
}
\description{
Show an object as musical score or audio file.
}
\section{Methods (by class)}{
\itemize{
\item \code{Music}: show a \code{Music} object.
}}

\examples{
if (interactive()) {
  m <- Music() + Meter(4, 4) + Line(list("C4"), list(4))
  show(m, c("score", "audio"))
}
}
