\name{getNumRowsGLPK}
\alias{getNumRowsGLPK}
\alias{glp_get_num_rows}

\title{
  Retrieve Number of Rows
}

\description{
  Low level interface function to the GLPK function \code{glp_get_num_rows}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  getNumRowsGLPK(lp)
}

\arguments{
  \item{lp}{
    An object of class \code{"\linkS4class{glpkPtr}"} as returned by
    \code{\link{initProbGLPK}}. This is basically a pointer to a GLPK problem
    object.
  }
}

\details{
  Interface to the C function \code{getNumRows} which calls the GLPK
  function \code{glp_get_num_rows}.
}

\value{
  Returns the current number of rows in the specified
  problem object.
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee.
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }

