% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{anova2}
\alias{anova2}
\title{Comparison of nested Generalized Linear Models}
\usage{
anova2(
  object,
  ...,
  test = c("wald", "lr", "score", "gradient"),
  verbose = TRUE
)
}
\arguments{
\item{object}{an object of the class glm which is obtained from the fit of a generalized linear model.}

\item{...}{another objects of the class glm which are obtained from the fit of generalized linear models.}

\item{test}{an (optional) character string indicating the required type of test. The available options are: Wald ("wald"), Rao's score ("score"), Terrell's gradient ("gradient"), and likelihood ratio ("lr") tests. By default, \code{test} is set to be "wald".}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A matrix with three columns which contains the following:
\itemize{
\item \code{Chi:}{ The value of the statistic of the test.}
\item \code{Df:}{ The number of degrees of freedom.}
\item \code{Pr(>Chi):}{ The \emph{p}-value of the test computed using the Chi-square distribution.}
}
}
\description{
Allows to compare nested generalized linear models using Wald, score, gradient, and likelihood ratio tests.
}
\details{
The Wald, Rao's score and Terrell's gradient tests are performed using the expected Fisher information matrix.
}
\examples{
## Example 1
Auto <- ISLR::Auto
fit1 <- glm(mpg ~ weight, family=inverse.gaussian("log"), data=Auto)
fit2 <- update(fit1, . ~ . + horsepower)
fit3 <- update(fit2, . ~ . + horsepower:weight)
anova2(fit1, fit2, fit3, test="lr")
anova2(fit1, fit2, fit3, test="score")
anova2(fit1, fit2, fit3, test="wald")
anova2(fit1, fit2, fit3, test="gradient")

## Example 2
burn1000 <- aplore3::burn1000
mod <- death ~ age + tbsa + inh_inj
fit1 <- glm(mod, family=binomial("logit"), data=burn1000)
fit2 <- update(fit1, . ~ . + inh_inj + age*inh_inj + tbsa*inh_inj)
anova2(fit1, fit2, test="lr")
anova2(fit1, fit2, test="score")
anova2(fit1, fit2, test="wald")
anova2(fit1, fit2, test="gradient")

## Example 3
fit <- glm(lesions ~ 1 + time, family=poisson("log"), data=aucuba)
anova2(fit, test="lr")
anova2(fit, test="score")
anova2(fit, test="wald")
anova2(fit, test="gradient")
}
\references{
Buse A. (1982) The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note. \emph{The American Statistician} 36, 153-157.

Terrell G.R. (2002) The gradient statistic. \emph{Computing Science and Statistics} 34, 206 – 215.
}
