% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{gvif.lm}
\alias{gvif.lm}
\title{Generalized Variance Inflaction Factor}
\usage{
\method{gvif}{lm}(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{an object of the class lm which is obtained from the fit of a normal linear model.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with so many rows as effects in the model and three columns: \emph{(1)} the values of GVIF; \emph{(2)} the number of degrees of freedom; and \emph{(3)} the values of GVIF^{1/(2*df)}.

If the number of degrees of freedom is 1 then the GVIF reduces to the Variance Inflation Factor (VIF).
}
\description{
Computes the generalized variance inflaction factor (GVIF) for a normal linear model.
}
\examples{
## Example 1
fit1 <- lm(mpg ~ log(hp) + log(wt), data=mtcars)
gvif(fit1)

## Example 2
fit2 <- lm(Species ~ Biomass + pH, data=richness)
gvif(fit2)

## Example 3
whiteside <- MASS::whiteside
fit3 <- lm(Gas ~ Temp + Insul + Temp*Insul, data=whiteside)
gvif(fit3)
}
\references{
Fox J. and Monette G. (1992) Generalized collinearity diagnostics, \emph{JASA} 87, 178–183.
}
\seealso{
\link{gvif.glm}
}
