% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calplot_240420.R
\name{calplot0}
\alias{calplot0}
\title{Construct a single calibration plot for a nested.glmnetr output object}
\usage{
calplot0(
  object1,
  wbeta = NULL,
  df = 5,
  cv = 1,
  trim = 0,
  fold = NULL,
  collapse = 0,
  plot = 1,
  lwd = 1,
  title = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  col.term = 1,
  col.se = 2,
  rug = 1,
  plothr = 0,
  ...
)
}
\arguments{
\item{object1}{A nested.glmnetr() output object for calibration}

\item{wbeta}{Which Beta should be plotted, an integer.  This will depend on
which machine learning models were run when creating the output object.   If 
unsure the user can run the function without specifying wbeta and a legend 
will be directed to the console.}

\item{df}{The degrees of freedom for the spline function, default=5.}

\item{cv}{1 to base the splines on the leave out X*Beta's ($xbetas.cv), or 0 to 
use the naive X*Beta's ($xbetas).}

\item{trim}{the percent of top and bottom of the data to be trimed way when 
producing plots.}

\item{fold}{the leave out fold to be selected for calibration or NULL to 
calibrate with all data.}

\item{collapse}{Collapse or combine pairs of hold out folds before dong the 
separate spline fits for calibration.  Intuitively it might make the spline 
fits more stable but empirically it doesn't seem to.}

\item{plot}{1 by default to plot the calibration}

\item{lwd}{line width for plots, 1 by default}

\item{title}{title for inclusion on plots, default NULL}

\item{xlim}{xlim for the plots.  This does not effect the curves within 
the plotted region.  Caution, for the "cox" framework the xlim are specified
in terms of the X*beta and not the HR, even when HR is described on the axes.}

\item{ylim}{ylim for the plots, which will usually only be specified in a 
second run of for the same data.  This does not effect the curves within 
the plotted region.  Caution, for the "cox" framework the ylim are specified
in terms of the X*beta and not the HR, even when HR is described on the axes.}

\item{xlab}{a user specified label for the x axis}

\item{ylab}{a user specified label for the y axis}

\item{col.term}{a number for the line depicting the overall calibration estimates}

\item{col.se}{a number for the line depicting the +/- 2 * standard error 
lines for the overall calibration estimates}

\item{rug}{1 to plot a rug for the model x*betas, 0 (default) to not.}

\item{plothr}{a power > 1 determining the spacing of the values 
on the axes, e.g. 2, exp(1), sqrt(10) or 10.  The default of 0 plots the 
X*Beta.  This only applies for "cox" survival data models.}

\item{...}{allowance to pass terms to the invoked plot function}
}
\value{
Plots are returned by default, and optionally data for plots are 
output to a list.
}
\description{
Construct a single calibration plot for a nested.glmnetr output object
}
\author{
Walter Kremers (kremers.walter@mayo.edu)
}
