% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested.glmnetr_230218.R
\name{nested.glmnetr}
\alias{nested.glmnetr}
\title{Using nested cross validation, describe the fit of a cross validation informed relaxed lasso model fit.}
\usage{
nested.glmnetr(
  xs,
  start = NULL,
  y_,
  event,
  family = NULL,
  steps_n = 0,
  folds_n = 10,
  dolasso = 1,
  dorpart = 0,
  doaic = 0,
  dostep = 0,
  method = "loglik",
  lambda = NULL,
  gamma = NULL,
  relax = TRUE,
  limit = 1,
  fine = 0,
  track = 0,
  seed = NULL,
  foldid = NULL,
  ties = "efron",
  time = NULL,
  ...
)
}
\arguments{
\item{xs}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{start}{start time, Cox model only - class numeric of length same as number of patients (n)}

\item{y_}{output vector: time, or stop time for Cox model, Y_ 0 or 1 for binomal (logistic), numeric for gaussian. 
Must be a vector of length same as number of sample size.}

\item{event}{event indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{family}{model family, "cox", "binomial" or "gaussian"}

\item{steps_n}{number of steps done in stepwise regression fitting}

\item{folds_n}{number of folds for each level of cross validation}

\item{dolasso}{fit and do cross validition for lasso model, 0 or 1}

\item{dorpart}{Do a nested cross validation for an RPART model.  As rpart() does its
own approximaiton for cross validation there is no new functions for RPART itself.}

\item{doaic}{fit and do cross validation for AIC fit, 0 or 1.
This is provided for reference only and is not recommended.}

\item{dostep}{fit and do cross validation for stepwise regression fit, 0 or 1, 
as discussed in James, Witten, Hastie and Tibshirani, 2nd edition.}

\item{method}{method for choosing model in stepwise procedure, "loglik" or "concordance".
Other procedures use the "loglik".}

\item{lambda}{lambda vector for teh lasso fit}

\item{gamma}{gamma vector for the relaxed lasso fit, default is c(0,0.25,0.5,0.75,1).}

\item{relax}{fit the relaxed lasso model when fitting a lasso model.}

\item{limit}{limit the small values for lambda after the initial fit.
This will calculations that have minimal impact on the cross validation.  
Default is 2 for moderate limitation, 1 for less limitation, 0 for none.}

\item{fine}{use a finer step in determining lambda.  Of little value unless one 
repeats the cross valiaiton many times to more finely tune the hyper paramters.  
See the 'glmnet' package documentation.}

\item{track}{track progress by printing to console elapsed and split times.}

\item{seed}{a seed for set.seed() to assure one can get the same results twice.  If NULL 
the program will generate a random seed.  Whether specified or NULL, the seed is stored in the output
object for future reference.}

\item{foldid}{a vector of integers to associate each record to a fold.  Should be integers between 1 and folds_n.
These will only be used in the outer folds.}

\item{ties}{method for handling ties in Cox model for relaxed model component.  Default 
is "efron", optionally "breslow".  For penalized fits "breslow" is 
always used as in the 'glmnet' package.}

\item{time}{track progress by printing to console elapsed and split times.  Suggested to use
track option instead as time option will be discontinued.}

\item{...}{Additional arguments that can be passed to glmnet()}
}
\value{
- The fit of a cross validation informed relaxed lasso model fit, obtained by nested cross validation.
}
\description{
Performs a nested cross validation for a cross validation 
informed relaxed lasso model.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$y_ 
# for this example we use a small number for folds_n to shorten run time 
nested.glmnetr.fit = nested.glmnetr( xs, NULL, y_, NULL, family="gaussian", folds_n=3)
plot(nested.glmnetr.fit) 
plot(nested.glmnetr.fit, coefs=TRUE) 
summary(nested.glmnetr.fit) 
summary(nested.glmnetr.fit, cvfit=TRUE) 
}

}
\seealso{
\code{\link{glmnetr}} , \code{\link{cv.glmnetr}}  , \code{\link{glmnetr.simdata}} , \code{\link{summary.nested.glmnetr}} , \code{\link{glmnetr.compcv}} , \code{\link{plot.nested.glmnetr}}
}
