
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_glmmfields_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_glmmfields");
    reader.add_event(261, 261, "end", "model_glmmfields");
    return reader;
}

class model_glmmfields : public prob_grad {
private:
    int nKnots;
    int nLocs;
    int nT;
    int N;
    vector<int> stationID;
    vector<int> yearID;
    vector<double> y;
    vector<int> y_int;
    vector<double> prior_gp_theta;
    vector<double> prior_gp_sigma;
    vector<double> prior_sigma;
    vector<double> prior_rw_sigma;
    vector<double> prior_intercept;
    vector<double> prior_beta;
    vector<double> prior_phi;
    matrix_d distKnots;
    matrix_d distKnots21;
    int nCov;
    matrix_d X;
    int cov_func;
    int est_df;
    int est_phi;
    int norm_params;
    int gamma_params;
    int nb2_params;
    int obs_model;
    double fixed_df_value;
    double fixed_phi_value;
    int est_temporalRE;
    int n_year_effects;
    int lower_truncation;
    int fixed_intercept;
    double matern_kappa;
    int nW;
    double gp_sigma_scaling_factor;
    double df_lower_bound;
public:
    model_glmmfields(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_glmmfields(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_glmmfields_namespace::model_glmmfields";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "nKnots", "int", context__.to_vec());
            nKnots = int(0);
            vals_i__ = context__.vals_i("nKnots");
            pos__ = 0;
            nKnots = vals_i__[pos__++];
            context__.validate_dims("data initialization", "nLocs", "int", context__.to_vec());
            nLocs = int(0);
            vals_i__ = context__.vals_i("nLocs");
            pos__ = 0;
            nLocs = vals_i__[pos__++];
            context__.validate_dims("data initialization", "nT", "int", context__.to_vec());
            nT = int(0);
            vals_i__ = context__.vals_i("nT");
            pos__ = 0;
            nT = vals_i__[pos__++];
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            validate_non_negative_index("stationID", "N", N);
            context__.validate_dims("data initialization", "stationID", "int", context__.to_vec(N));
            validate_non_negative_index("stationID", "N", N);
            stationID = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("stationID");
            pos__ = 0;
            size_t stationID_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < stationID_limit_0__; ++i_0__) {
                stationID[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("yearID", "N", N);
            context__.validate_dims("data initialization", "yearID", "int", context__.to_vec(N));
            validate_non_negative_index("yearID", "N", N);
            yearID = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("yearID");
            pos__ = 0;
            size_t yearID_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < yearID_limit_0__; ++i_0__) {
                yearID[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(N));
            validate_non_negative_index("y", "N", N);
            y = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
                y[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("y_int", "N", N);
            context__.validate_dims("data initialization", "y_int", "int", context__.to_vec(N));
            validate_non_negative_index("y_int", "N", N);
            y_int = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("y_int");
            pos__ = 0;
            size_t y_int_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < y_int_limit_0__; ++i_0__) {
                y_int[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("prior_gp_theta", "3", 3);
            context__.validate_dims("data initialization", "prior_gp_theta", "double", context__.to_vec(3));
            validate_non_negative_index("prior_gp_theta", "3", 3);
            prior_gp_theta = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_gp_theta");
            pos__ = 0;
            size_t prior_gp_theta_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_gp_theta_limit_0__; ++i_0__) {
                prior_gp_theta[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_gp_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_gp_sigma", "double", context__.to_vec(3));
            validate_non_negative_index("prior_gp_sigma", "3", 3);
            prior_gp_sigma = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_gp_sigma");
            pos__ = 0;
            size_t prior_gp_sigma_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_gp_sigma_limit_0__; ++i_0__) {
                prior_gp_sigma[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_sigma", "double", context__.to_vec(3));
            validate_non_negative_index("prior_sigma", "3", 3);
            prior_sigma = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_sigma");
            pos__ = 0;
            size_t prior_sigma_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_sigma_limit_0__; ++i_0__) {
                prior_sigma[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_rw_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_rw_sigma", "double", context__.to_vec(3));
            validate_non_negative_index("prior_rw_sigma", "3", 3);
            prior_rw_sigma = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_rw_sigma");
            pos__ = 0;
            size_t prior_rw_sigma_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_rw_sigma_limit_0__; ++i_0__) {
                prior_rw_sigma[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_intercept", "3", 3);
            context__.validate_dims("data initialization", "prior_intercept", "double", context__.to_vec(3));
            validate_non_negative_index("prior_intercept", "3", 3);
            prior_intercept = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_intercept");
            pos__ = 0;
            size_t prior_intercept_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_intercept_limit_0__; ++i_0__) {
                prior_intercept[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_beta", "3", 3);
            context__.validate_dims("data initialization", "prior_beta", "double", context__.to_vec(3));
            validate_non_negative_index("prior_beta", "3", 3);
            prior_beta = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_beta");
            pos__ = 0;
            size_t prior_beta_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_beta_limit_0__; ++i_0__) {
                prior_beta[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("prior_phi", "3", 3);
            context__.validate_dims("data initialization", "prior_phi", "double", context__.to_vec(3));
            validate_non_negative_index("prior_phi", "3", 3);
            prior_phi = std::vector<double>(3,double(0));
            vals_r__ = context__.vals_r("prior_phi");
            pos__ = 0;
            size_t prior_phi_limit_0__ = 3;
            for (size_t i_0__ = 0; i_0__ < prior_phi_limit_0__; ++i_0__) {
                prior_phi[i_0__] = vals_r__[pos__++];
            }
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            context__.validate_dims("data initialization", "distKnots", "matrix_d", context__.to_vec(nKnots,nKnots));
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            distKnots = matrix_d(static_cast<Eigen::VectorXd::Index>(nKnots),static_cast<Eigen::VectorXd::Index>(nKnots));
            vals_r__ = context__.vals_r("distKnots");
            pos__ = 0;
            size_t distKnots_m_mat_lim__ = nKnots;
            size_t distKnots_n_mat_lim__ = nKnots;
            for (size_t n_mat__ = 0; n_mat__ < distKnots_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < distKnots_m_mat_lim__; ++m_mat__) {
                    distKnots(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            validate_non_negative_index("distKnots21", "nLocs", nLocs);
            validate_non_negative_index("distKnots21", "nKnots", nKnots);
            context__.validate_dims("data initialization", "distKnots21", "matrix_d", context__.to_vec(nLocs,nKnots));
            validate_non_negative_index("distKnots21", "nLocs", nLocs);
            validate_non_negative_index("distKnots21", "nKnots", nKnots);
            distKnots21 = matrix_d(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            vals_r__ = context__.vals_r("distKnots21");
            pos__ = 0;
            size_t distKnots21_m_mat_lim__ = nLocs;
            size_t distKnots21_n_mat_lim__ = nKnots;
            for (size_t n_mat__ = 0; n_mat__ < distKnots21_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < distKnots21_m_mat_lim__; ++m_mat__) {
                    distKnots21(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            context__.validate_dims("data initialization", "nCov", "int", context__.to_vec());
            nCov = int(0);
            vals_i__ = context__.vals_i("nCov");
            pos__ = 0;
            nCov = vals_i__[pos__++];
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "nCov", nCov);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,nCov));
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "nCov", nCov);
            X = matrix_d(static_cast<Eigen::VectorXd::Index>(N),static_cast<Eigen::VectorXd::Index>(nCov));
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_m_mat_lim__ = N;
            size_t X_n_mat_lim__ = nCov;
            for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
                for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                    X(m_mat__,n_mat__) = vals_r__[pos__++];
                }
            }
            context__.validate_dims("data initialization", "cov_func", "int", context__.to_vec());
            cov_func = int(0);
            vals_i__ = context__.vals_i("cov_func");
            pos__ = 0;
            cov_func = vals_i__[pos__++];
            context__.validate_dims("data initialization", "est_df", "int", context__.to_vec());
            est_df = int(0);
            vals_i__ = context__.vals_i("est_df");
            pos__ = 0;
            est_df = vals_i__[pos__++];
            context__.validate_dims("data initialization", "est_phi", "int", context__.to_vec());
            est_phi = int(0);
            vals_i__ = context__.vals_i("est_phi");
            pos__ = 0;
            est_phi = vals_i__[pos__++];
            context__.validate_dims("data initialization", "norm_params", "int", context__.to_vec());
            norm_params = int(0);
            vals_i__ = context__.vals_i("norm_params");
            pos__ = 0;
            norm_params = vals_i__[pos__++];
            context__.validate_dims("data initialization", "gamma_params", "int", context__.to_vec());
            gamma_params = int(0);
            vals_i__ = context__.vals_i("gamma_params");
            pos__ = 0;
            gamma_params = vals_i__[pos__++];
            context__.validate_dims("data initialization", "nb2_params", "int", context__.to_vec());
            nb2_params = int(0);
            vals_i__ = context__.vals_i("nb2_params");
            pos__ = 0;
            nb2_params = vals_i__[pos__++];
            context__.validate_dims("data initialization", "obs_model", "int", context__.to_vec());
            obs_model = int(0);
            vals_i__ = context__.vals_i("obs_model");
            pos__ = 0;
            obs_model = vals_i__[pos__++];
            context__.validate_dims("data initialization", "fixed_df_value", "double", context__.to_vec());
            fixed_df_value = double(0);
            vals_r__ = context__.vals_r("fixed_df_value");
            pos__ = 0;
            fixed_df_value = vals_r__[pos__++];
            context__.validate_dims("data initialization", "fixed_phi_value", "double", context__.to_vec());
            fixed_phi_value = double(0);
            vals_r__ = context__.vals_r("fixed_phi_value");
            pos__ = 0;
            fixed_phi_value = vals_r__[pos__++];
            context__.validate_dims("data initialization", "est_temporalRE", "int", context__.to_vec());
            est_temporalRE = int(0);
            vals_i__ = context__.vals_i("est_temporalRE");
            pos__ = 0;
            est_temporalRE = vals_i__[pos__++];
            context__.validate_dims("data initialization", "n_year_effects", "int", context__.to_vec());
            n_year_effects = int(0);
            vals_i__ = context__.vals_i("n_year_effects");
            pos__ = 0;
            n_year_effects = vals_i__[pos__++];
            context__.validate_dims("data initialization", "lower_truncation", "int", context__.to_vec());
            lower_truncation = int(0);
            vals_i__ = context__.vals_i("lower_truncation");
            pos__ = 0;
            lower_truncation = vals_i__[pos__++];
            context__.validate_dims("data initialization", "fixed_intercept", "int", context__.to_vec());
            fixed_intercept = int(0);
            vals_i__ = context__.vals_i("fixed_intercept");
            pos__ = 0;
            fixed_intercept = vals_i__[pos__++];
            context__.validate_dims("data initialization", "matern_kappa", "double", context__.to_vec());
            matern_kappa = double(0);
            vals_r__ = context__.vals_r("matern_kappa");
            pos__ = 0;
            matern_kappa = vals_r__[pos__++];
            context__.validate_dims("data initialization", "nW", "int", context__.to_vec());
            nW = int(0);
            vals_i__ = context__.vals_i("nW");
            pos__ = 0;
            nW = vals_i__[pos__++];
            context__.validate_dims("data initialization", "gp_sigma_scaling_factor", "double", context__.to_vec());
            gp_sigma_scaling_factor = double(0);
            vals_r__ = context__.vals_r("gp_sigma_scaling_factor");
            pos__ = 0;
            gp_sigma_scaling_factor = vals_r__[pos__++];
            context__.validate_dims("data initialization", "df_lower_bound", "double", context__.to_vec());
            df_lower_bound = double(0);
            vals_r__ = context__.vals_r("df_lower_bound");
            pos__ = 0;
            df_lower_bound = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"nKnots",nKnots,1);
            check_greater_or_equal(function__,"nLocs",nLocs,1);
            check_greater_or_equal(function__,"nT",nT,1);
            check_greater_or_equal(function__,"N",N,1);
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"stationID[k0__]",stationID[k0__],1);
            }
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"yearID[k0__]",yearID[k0__],1);
            }
            check_greater_or_equal(function__,"nCov",nCov,0);
            check_greater_or_equal(function__,"cov_func",cov_func,0);
            check_less_or_equal(function__,"cov_func",cov_func,2);
            check_greater_or_equal(function__,"est_df",est_df,0);
            check_less_or_equal(function__,"est_df",est_df,1);
            check_greater_or_equal(function__,"est_phi",est_phi,0);
            check_less_or_equal(function__,"est_phi",est_phi,1);
            check_greater_or_equal(function__,"norm_params",norm_params,0);
            check_less_or_equal(function__,"norm_params",norm_params,1);
            check_greater_or_equal(function__,"gamma_params",gamma_params,0);
            check_less_or_equal(function__,"gamma_params",gamma_params,1);
            check_greater_or_equal(function__,"nb2_params",nb2_params,0);
            check_less_or_equal(function__,"nb2_params",nb2_params,1);
            check_greater_or_equal(function__,"obs_model",obs_model,0);
            check_less_or_equal(function__,"obs_model",obs_model,6);
            check_greater_or_equal(function__,"fixed_df_value",fixed_df_value,1);
            check_greater_or_equal(function__,"est_temporalRE",est_temporalRE,0);
            check_less_or_equal(function__,"est_temporalRE",est_temporalRE,1);
            check_greater_or_equal(function__,"n_year_effects",n_year_effects,0);
            check_greater_or_equal(function__,"lower_truncation",lower_truncation,0);
            check_greater_or_equal(function__,"fixed_intercept",fixed_intercept,0);
            check_less_or_equal(function__,"fixed_intercept",fixed_intercept,1);
            check_greater_or_equal(function__,"nW",nW,0);
            check_less_or_equal(function__,"nW",nW,nT);
            check_greater_or_equal(function__,"gp_sigma_scaling_factor",gp_sigma_scaling_factor,0);
            check_greater_or_equal(function__,"df_lower_bound",df_lower_bound,1);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
            validate_non_negative_index("df", "est_df", est_df);
            num_params_r__ += est_df;
            validate_non_negative_index("sigma", "norm_params", norm_params);
            num_params_r__ += norm_params;
            validate_non_negative_index("CV", "gamma_params", gamma_params);
            num_params_r__ += gamma_params;
            validate_non_negative_index("nb2_phi", "nb2_params", nb2_params);
            num_params_r__ += nb2_params;
            validate_non_negative_index("yearEffects", "n_year_effects", n_year_effects);
            num_params_r__ += n_year_effects;
            validate_non_negative_index("year_sigma", "est_temporalRE", est_temporalRE);
            num_params_r__ += est_temporalRE;
            validate_non_negative_index("spatialEffectsKnots", "nKnots", nKnots);
            validate_non_negative_index("spatialEffectsKnots", "nT", nT);
            num_params_r__ += nKnots * nT;
            validate_non_negative_index("B", "nCov", nCov);
            num_params_r__ += nCov;
            validate_non_negative_index("phi", "est_phi", est_phi);
            num_params_r__ += est_phi;
            validate_non_negative_index("W", "nW", nW);
            num_params_r__ += nW;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_glmmfields() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("gp_theta")))
            throw std::runtime_error("variable gp_theta missing");
        vals_r__ = context__.vals_r("gp_theta");
        pos__ = 0U;
        context__.validate_dims("initialization", "gp_theta", "double", context__.to_vec());
        double gp_theta(0);
        gp_theta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,gp_theta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gp_theta: ") + e.what());
        }

        if (!(context__.contains_r("gp_sigma")))
            throw std::runtime_error("variable gp_sigma missing");
        vals_r__ = context__.vals_r("gp_sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gp_sigma", "double", context__.to_vec());
        double gp_sigma(0);
        gp_sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,gp_sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gp_sigma: ") + e.what());
        }

        if (!(context__.contains_r("df")))
            throw std::runtime_error("variable df missing");
        vals_r__ = context__.vals_r("df");
        pos__ = 0U;
        validate_non_negative_index("df", "est_df", est_df);
        context__.validate_dims("initialization", "df", "double", context__.to_vec(est_df));
        std::vector<double> df(est_df,double(0));
        for (int i0__ = 0U; i0__ < est_df; ++i0__)
            df[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < est_df; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(df_lower_bound,df[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable df: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "norm_params", norm_params);
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec(norm_params));
        std::vector<double> sigma(norm_params,double(0));
        for (int i0__ = 0U; i0__ < norm_params; ++i0__)
            sigma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < norm_params; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,sigma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("CV")))
            throw std::runtime_error("variable CV missing");
        vals_r__ = context__.vals_r("CV");
        pos__ = 0U;
        validate_non_negative_index("CV", "gamma_params", gamma_params);
        context__.validate_dims("initialization", "CV", "double", context__.to_vec(gamma_params));
        std::vector<double> CV(gamma_params,double(0));
        for (int i0__ = 0U; i0__ < gamma_params; ++i0__)
            CV[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < gamma_params; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,CV[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable CV: ") + e.what());
        }

        if (!(context__.contains_r("nb2_phi")))
            throw std::runtime_error("variable nb2_phi missing");
        vals_r__ = context__.vals_r("nb2_phi");
        pos__ = 0U;
        validate_non_negative_index("nb2_phi", "nb2_params", nb2_params);
        context__.validate_dims("initialization", "nb2_phi", "double", context__.to_vec(nb2_params));
        std::vector<double> nb2_phi(nb2_params,double(0));
        for (int i0__ = 0U; i0__ < nb2_params; ++i0__)
            nb2_phi[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nb2_params; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,nb2_phi[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nb2_phi: ") + e.what());
        }

        if (!(context__.contains_r("yearEffects")))
            throw std::runtime_error("variable yearEffects missing");
        vals_r__ = context__.vals_r("yearEffects");
        pos__ = 0U;
        validate_non_negative_index("yearEffects", "n_year_effects", n_year_effects);
        context__.validate_dims("initialization", "yearEffects", "double", context__.to_vec(n_year_effects));
        std::vector<double> yearEffects(n_year_effects,double(0));
        for (int i0__ = 0U; i0__ < n_year_effects; ++i0__)
            yearEffects[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < n_year_effects; ++i0__)
            try {
            writer__.scalar_unconstrain(yearEffects[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable yearEffects: ") + e.what());
        }

        if (!(context__.contains_r("year_sigma")))
            throw std::runtime_error("variable year_sigma missing");
        vals_r__ = context__.vals_r("year_sigma");
        pos__ = 0U;
        validate_non_negative_index("year_sigma", "est_temporalRE", est_temporalRE);
        context__.validate_dims("initialization", "year_sigma", "double", context__.to_vec(est_temporalRE));
        std::vector<double> year_sigma(est_temporalRE,double(0));
        for (int i0__ = 0U; i0__ < est_temporalRE; ++i0__)
            year_sigma[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < est_temporalRE; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,year_sigma[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable year_sigma: ") + e.what());
        }

        if (!(context__.contains_r("spatialEffectsKnots")))
            throw std::runtime_error("variable spatialEffectsKnots missing");
        vals_r__ = context__.vals_r("spatialEffectsKnots");
        pos__ = 0U;
        validate_non_negative_index("spatialEffectsKnots", "nT", nT);
        validate_non_negative_index("spatialEffectsKnots", "nKnots", nKnots);
        context__.validate_dims("initialization", "spatialEffectsKnots", "vector_d", context__.to_vec(nT,nKnots));
        std::vector<vector_d> spatialEffectsKnots(nT,vector_d(static_cast<Eigen::VectorXd::Index>(nKnots)));
        for (int j1__ = 0U; j1__ < nKnots; ++j1__)
            for (int i0__ = 0U; i0__ < nT; ++i0__)
                spatialEffectsKnots[i0__](j1__) = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nT; ++i0__)
            try {
            writer__.vector_unconstrain(spatialEffectsKnots[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable spatialEffectsKnots: ") + e.what());
        }

        if (!(context__.contains_r("B")))
            throw std::runtime_error("variable B missing");
        vals_r__ = context__.vals_r("B");
        pos__ = 0U;
        validate_non_negative_index("B", "nCov", nCov);
        context__.validate_dims("initialization", "B", "vector_d", context__.to_vec(nCov));
        vector_d B(static_cast<Eigen::VectorXd::Index>(nCov));
        for (int j1__ = 0U; j1__ < nCov; ++j1__)
            B(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(B);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable B: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "est_phi", est_phi);
        context__.validate_dims("initialization", "phi", "double", context__.to_vec(est_phi));
        std::vector<double> phi(est_phi,double(0));
        for (int i0__ = 0U; i0__ < est_phi; ++i0__)
            phi[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < est_phi; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(-(1),1,phi[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        if (!(context__.contains_r("W")))
            throw std::runtime_error("variable W missing");
        vals_r__ = context__.vals_r("W");
        pos__ = 0U;
        validate_non_negative_index("W", "nW", nW);
        context__.validate_dims("initialization", "W", "double", context__.to_vec(nW));
        std::vector<double> W(nW,double(0));
        for (int i0__ = 0U; i0__ < nW; ++i0__)
            W[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < nW; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,W[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable W: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ gp_theta;
            (void) gp_theta;  // dummy to suppress unused var warning
            if (jacobian__)
                gp_theta = in__.scalar_lb_constrain(0,lp__);
            else
                gp_theta = in__.scalar_lb_constrain(0);

            T__ gp_sigma;
            (void) gp_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                gp_sigma = in__.scalar_lb_constrain(0,lp__);
            else
                gp_sigma = in__.scalar_lb_constrain(0);

            vector<T__> df;
            size_t dim_df_0__ = est_df;
            df.reserve(dim_df_0__);
            for (size_t k_0__ = 0; k_0__ < dim_df_0__; ++k_0__) {
                if (jacobian__)
                    df.push_back(in__.scalar_lb_constrain(df_lower_bound,lp__));
                else
                    df.push_back(in__.scalar_lb_constrain(df_lower_bound));
            }

            vector<T__> sigma;
            size_t dim_sigma_0__ = norm_params;
            sigma.reserve(dim_sigma_0__);
            for (size_t k_0__ = 0; k_0__ < dim_sigma_0__; ++k_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }

            vector<T__> CV;
            size_t dim_CV_0__ = gamma_params;
            CV.reserve(dim_CV_0__);
            for (size_t k_0__ = 0; k_0__ < dim_CV_0__; ++k_0__) {
                if (jacobian__)
                    CV.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    CV.push_back(in__.scalar_lb_constrain(0));
            }

            vector<T__> nb2_phi;
            size_t dim_nb2_phi_0__ = nb2_params;
            nb2_phi.reserve(dim_nb2_phi_0__);
            for (size_t k_0__ = 0; k_0__ < dim_nb2_phi_0__; ++k_0__) {
                if (jacobian__)
                    nb2_phi.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    nb2_phi.push_back(in__.scalar_lb_constrain(0));
            }

            vector<T__> yearEffects;
            size_t dim_yearEffects_0__ = n_year_effects;
            yearEffects.reserve(dim_yearEffects_0__);
            for (size_t k_0__ = 0; k_0__ < dim_yearEffects_0__; ++k_0__) {
                if (jacobian__)
                    yearEffects.push_back(in__.scalar_constrain(lp__));
                else
                    yearEffects.push_back(in__.scalar_constrain());
            }

            vector<T__> year_sigma;
            size_t dim_year_sigma_0__ = est_temporalRE;
            year_sigma.reserve(dim_year_sigma_0__);
            for (size_t k_0__ = 0; k_0__ < dim_year_sigma_0__; ++k_0__) {
                if (jacobian__)
                    year_sigma.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    year_sigma.push_back(in__.scalar_lb_constrain(0));
            }

            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > spatialEffectsKnots;
            size_t dim_spatialEffectsKnots_0__ = nT;
            spatialEffectsKnots.reserve(dim_spatialEffectsKnots_0__);
            for (size_t k_0__ = 0; k_0__ < dim_spatialEffectsKnots_0__; ++k_0__) {
                if (jacobian__)
                    spatialEffectsKnots.push_back(in__.vector_constrain(nKnots,lp__));
                else
                    spatialEffectsKnots.push_back(in__.vector_constrain(nKnots));
            }

            Eigen::Matrix<T__,Eigen::Dynamic,1>  B;
            (void) B;  // dummy to suppress unused var warning
            if (jacobian__)
                B = in__.vector_constrain(nCov,lp__);
            else
                B = in__.vector_constrain(nCov);

            vector<T__> phi;
            size_t dim_phi_0__ = est_phi;
            phi.reserve(dim_phi_0__);
            for (size_t k_0__ = 0; k_0__ < dim_phi_0__; ++k_0__) {
                if (jacobian__)
                    phi.push_back(in__.scalar_lub_constrain(-(1),1,lp__));
                else
                    phi.push_back(in__.scalar_lub_constrain(-(1),1));
            }

            vector<T__> W;
            size_t dim_W_0__ = nW;
            W.reserve(dim_W_0__);
            for (size_t k_0__ = 0; k_0__ < dim_W_0__; ++k_0__) {
                if (jacobian__)
                    W.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    W.push_back(in__.scalar_lb_constrain(0));
            }


            // transformed parameters
            validate_non_negative_index("muZeros", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  muZeros(static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) muZeros;  // dummy to suppress unused var warning

            stan::math::initialize(muZeros, DUMMY_VAR__);
            stan::math::fill(muZeros,DUMMY_VAR__);
            validate_non_negative_index("spatialEffects", "nLocs", nLocs);
            validate_non_negative_index("spatialEffects", "nT", nT);
            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > spatialEffects(nT, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(nLocs))));
            stan::math::initialize(spatialEffects, DUMMY_VAR__);
            stan::math::fill(spatialEffects,DUMMY_VAR__);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  SigmaKnots(static_cast<Eigen::VectorXd::Index>(nKnots),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) SigmaKnots;  // dummy to suppress unused var warning

            stan::math::initialize(SigmaKnots, DUMMY_VAR__);
            stan::math::fill(SigmaKnots,DUMMY_VAR__);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  transformed_dist(static_cast<Eigen::VectorXd::Index>(nKnots),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) transformed_dist;  // dummy to suppress unused var warning

            stan::math::initialize(transformed_dist, DUMMY_VAR__);
            stan::math::fill(transformed_dist,DUMMY_VAR__);
            validate_non_negative_index("transformed_dist21", "nLocs", nLocs);
            validate_non_negative_index("transformed_dist21", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  transformed_dist21(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) transformed_dist21;  // dummy to suppress unused var warning

            stan::math::initialize(transformed_dist21, DUMMY_VAR__);
            stan::math::fill(transformed_dist21,DUMMY_VAR__);
            validate_non_negative_index("SigmaOffDiag", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiag", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  SigmaOffDiag(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) SigmaOffDiag;  // dummy to suppress unused var warning

            stan::math::initialize(SigmaOffDiag, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiag,DUMMY_VAR__);
            validate_non_negative_index("invSigmaKnots", "nLocs", nLocs);
            validate_non_negative_index("invSigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<T__,Eigen::Dynamic,Eigen::Dynamic>  invSigmaKnots(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) invSigmaKnots;  // dummy to suppress unused var warning

            stan::math::initialize(invSigmaKnots, DUMMY_VAR__);
            stan::math::fill(invSigmaKnots,DUMMY_VAR__);
            validate_non_negative_index("y_hat", "N", N);
            Eigen::Matrix<T__,Eigen::Dynamic,1>  y_hat(static_cast<Eigen::VectorXd::Index>(N));
            (void) y_hat;  // dummy to suppress unused var warning

            stan::math::initialize(y_hat, DUMMY_VAR__);
            stan::math::fill(y_hat,DUMMY_VAR__);
            validate_non_negative_index("gammaA", "gamma_params", gamma_params);
            vector<T__> gammaA(gamma_params);
            stan::math::initialize(gammaA, DUMMY_VAR__);
            stan::math::fill(gammaA,DUMMY_VAR__);
            T__ gp_sigma_sq;
            (void) gp_sigma_sq;  // dummy to suppress unused var warning

            stan::math::initialize(gp_sigma_sq, DUMMY_VAR__);
            stan::math::fill(gp_sigma_sq,DUMMY_VAR__);


            stan::math::assign(gp_sigma_sq, pow((gp_sigma * gp_sigma_scaling_factor),2.0));
            if (as_bool(logical_eq(cov_func,0))) {

                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq,exp(divide(minus(distKnots),gp_theta))));
                stan::math::assign(SigmaOffDiag, multiply(gp_sigma_sq,exp(divide(minus(distKnots21),gp_theta))));
            }
            if (as_bool(logical_eq(cov_func,1))) {

                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq,exp(multiply(-(inv((2.0 * pow(gp_theta,2.0)))),distKnots))));
                stan::math::assign(SigmaOffDiag, multiply(gp_sigma_sq,exp(multiply(-(inv((2.0 * pow(gp_theta,2.0)))),distKnots21))));
            }
            if (as_bool(logical_eq(cov_func,2))) {

                if (as_bool(logical_eq(matern_kappa,1.5))) {

                    stan::math::assign(transformed_dist, divide(multiply(sqrt(3.0),distKnots),gp_theta));
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq,add(1.0,transformed_dist)),exp(minus(transformed_dist))));
                    stan::math::assign(transformed_dist21, divide(multiply(sqrt(3.0),distKnots21),gp_theta));
                    stan::math::assign(SigmaOffDiag, elt_multiply(multiply(gp_sigma_sq,add(1.0,transformed_dist21)),exp(minus(transformed_dist21))));
                }
                if (as_bool(logical_eq(matern_kappa,2.5))) {

                    stan::math::assign(transformed_dist, divide(multiply(sqrt(5.0),distKnots),gp_theta));
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq,add(add(1.0,transformed_dist),divide(elt_multiply(transformed_dist,transformed_dist),3.0))),exp(minus(transformed_dist))));
                    stan::math::assign(transformed_dist21, divide(multiply(sqrt(5.0),distKnots21),gp_theta));
                    stan::math::assign(SigmaOffDiag, elt_multiply(multiply(gp_sigma_sq,add(add(1.0,transformed_dist21),divide(elt_multiply(transformed_dist21,transformed_dist21),3.0))),exp(minus(transformed_dist21))));
                }
            }
            for (int k = 1; k <= nKnots; ++k) {

                stan::math::assign(get_base1_lhs(muZeros,k,"muZeros",1), 0);
            }
            stan::math::assign(SigmaOffDiag, multiply(SigmaOffDiag,inverse_spd(SigmaKnots)));
            for (int t = 1; t <= nT; ++t) {

                stan::math::assign(get_base1_lhs(spatialEffects,t,"spatialEffects",1), multiply(SigmaOffDiag,get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1)));
            }
            for (int i = 1; i <= N; ++i) {

                if (as_bool(logical_eq(est_temporalRE,0))) {

                    if (as_bool(logical_eq(fixed_intercept,0))) {

                        stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), (multiply(get_base1(X,i,"X",1),B) + get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2)));
                    } else {

                        stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2));
                    }
                } else {

                    stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), (get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2) + get_base1(yearEffects,get_base1(yearID,i,"yearID",1),"yearEffects",1)));
                }
            }
            if (as_bool(logical_eq(obs_model,0))) {

                stan::math::assign(get_base1_lhs(gammaA,1,"gammaA",1), inv(pow(get_base1(CV,1,"CV",1),2.0)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < nKnots; ++i0__) {
                if (stan::math::is_uninitialized(muZeros(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: muZeros" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < nT; ++i0__) {
                for (int i1__ = 0; i1__ < nLocs; ++i1__) {
                    if (stan::math::is_uninitialized(spatialEffects[i0__](i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: spatialEffects" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < nKnots; ++i0__) {
                for (int i1__ = 0; i1__ < nKnots; ++i1__) {
                    if (stan::math::is_uninitialized(SigmaKnots(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SigmaKnots" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < nKnots; ++i0__) {
                for (int i1__ = 0; i1__ < nKnots; ++i1__) {
                    if (stan::math::is_uninitialized(transformed_dist(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transformed_dist" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < nLocs; ++i0__) {
                for (int i1__ = 0; i1__ < nKnots; ++i1__) {
                    if (stan::math::is_uninitialized(transformed_dist21(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transformed_dist21" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < nLocs; ++i0__) {
                for (int i1__ = 0; i1__ < nKnots; ++i1__) {
                    if (stan::math::is_uninitialized(SigmaOffDiag(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SigmaOffDiag" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < nLocs; ++i0__) {
                for (int i1__ = 0; i1__ < nKnots; ++i1__) {
                    if (stan::math::is_uninitialized(invSigmaKnots(i0__,i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: invSigmaKnots" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(y_hat(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: y_hat" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < gamma_params; ++i0__) {
                if (stan::math::is_uninitialized(gammaA[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gammaA" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            if (stan::math::is_uninitialized(gp_sigma_sq)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gp_sigma_sq";
                throw std::runtime_error(msg__.str());
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < gamma_params; ++k0__) {
                check_greater_or_equal(function__,"gammaA[k0__]",gammaA[k0__],0);
            }
            check_greater_or_equal(function__,"gp_sigma_sq",gp_sigma_sq,0);

            // model body

            lp_accum__.add(student_t_log<propto__>(gp_theta, get_base1(prior_gp_theta,1,"prior_gp_theta",1), get_base1(prior_gp_theta,2,"prior_gp_theta",1), get_base1(prior_gp_theta,3,"prior_gp_theta",1)));
            lp_accum__.add(student_t_log<propto__>(gp_sigma, get_base1(prior_gp_sigma,1,"prior_gp_sigma",1), get_base1(prior_gp_sigma,2,"prior_gp_sigma",1), get_base1(prior_gp_sigma,3,"prior_gp_sigma",1)));
            if (as_bool(logical_eq(est_phi,1))) {

                lp_accum__.add(student_t_log<propto__>(phi, get_base1(prior_phi,1,"prior_phi",1), get_base1(prior_phi,2,"prior_phi",1), get_base1(prior_phi,3,"prior_phi",1)));
            }
            if (as_bool(logical_gte(nCov,1))) {

                lp_accum__.add(student_t_log<propto__>(get_base1(B,1,"B",1), get_base1(prior_intercept,1,"prior_intercept",1), get_base1(prior_intercept,2,"prior_intercept",1), get_base1(prior_intercept,3,"prior_intercept",1)));
            }
            if (as_bool(logical_gte(nCov,2))) {

                for (int i = 2; i <= nCov; ++i) {

                    lp_accum__.add(student_t_log<propto__>(get_base1(B,i,"B",1), get_base1(prior_beta,1,"prior_beta",1), get_base1(prior_beta,2,"prior_beta",1), get_base1(prior_beta,3,"prior_beta",1)));
                }
            }
            if (as_bool(logical_eq(est_temporalRE,1))) {

                lp_accum__.add(student_t_log<propto__>(year_sigma, get_base1(prior_rw_sigma,1,"prior_rw_sigma",1), get_base1(prior_rw_sigma,2,"prior_rw_sigma",1), get_base1(prior_rw_sigma,3,"prior_rw_sigma",1)));
                lp_accum__.add(student_t_log<propto__>(get_base1(yearEffects,1,"yearEffects",1), get_base1(prior_intercept,1,"prior_intercept",1), get_base1(prior_intercept,2,"prior_intercept",1), get_base1(prior_intercept,3,"prior_intercept",1)));
                for (int t = 2; t <= nT; ++t) {

                    lp_accum__.add(normal_log<propto__>(get_base1(yearEffects,t,"yearEffects",1), get_base1(yearEffects,(t - 1),"yearEffects",1), year_sigma));
                }
            }
            if (as_bool(logical_eq(est_df,1))) {

                lp_accum__.add(scaled_inv_chi_square_log<propto__>(W, get_base1(df,1,"df",1), 1));
                lp_accum__.add(gamma_log<propto__>(df, 2, 0.10000000000000001));
            } else {

                if (as_bool(logical_gt(nW,0))) {

                    lp_accum__.add(scaled_inv_chi_square_log<propto__>(W, fixed_df_value, 1));
                }
            }
            if (as_bool(logical_gt(nW,0))) {

                lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,1,"spatialEffectsKnots",1), muZeros, multiply(get_base1(W,1,"W",1),SigmaKnots)));
                for (int t = 2; t <= nT; ++t) {

                    if (as_bool(logical_eq(est_phi,1))) {

                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1), multiply(get_base1(phi,1,"phi",1),get_base1(spatialEffectsKnots,(t - 1),"spatialEffectsKnots",1)), multiply(get_base1(W,t,"W",1),SigmaKnots)));
                    } else {

                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1), multiply(fixed_phi_value,get_base1(spatialEffectsKnots,(t - 1),"spatialEffectsKnots",1)), multiply(get_base1(W,t,"W",1),SigmaKnots)));
                    }
                }
            } else {

                lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,1,"spatialEffectsKnots",1), muZeros, SigmaKnots));
                for (int t = 2; t <= nT; ++t) {

                    if (as_bool(logical_eq(est_phi,1))) {

                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1), multiply(get_base1(phi,1,"phi",1),get_base1(spatialEffectsKnots,(t - 1),"spatialEffectsKnots",1)), SigmaKnots));
                    } else {

                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1), multiply(fixed_phi_value,get_base1(spatialEffectsKnots,(t - 1),"spatialEffectsKnots",1)), SigmaKnots));
                    }
                }
            }
            if (as_bool(logical_eq(obs_model,0))) {

                lp_accum__.add(student_t_log<propto__>(get_base1(CV,1,"CV",1), get_base1(prior_sigma,1,"prior_sigma",1), get_base1(prior_sigma,2,"prior_sigma",1), get_base1(prior_sigma,3,"prior_sigma",1)));
                lp_accum__.add(gamma_log<propto__>(y, get_base1(gammaA,1,"gammaA",1), elt_divide(get_base1(gammaA,1,"gammaA",1),exp(y_hat))));
            }
            if (as_bool(logical_eq(obs_model,1))) {

                lp_accum__.add(student_t_log<propto__>(get_base1(sigma,1,"sigma",1), get_base1(prior_sigma,1,"prior_sigma",1), get_base1(prior_sigma,2,"prior_sigma",1), get_base1(prior_sigma,3,"prior_sigma",1)));
                lp_accum__.add(normal_log<propto__>(y, y_hat, get_base1(sigma,1,"sigma",1)));
            }
            if (as_bool(logical_eq(obs_model,2))) {

                lp_accum__.add(student_t_log<propto__>(get_base1(nb2_phi,1,"nb2_phi",1), get_base1(prior_sigma,1,"prior_sigma",1), get_base1(prior_sigma,2,"prior_sigma",1), get_base1(prior_sigma,3,"prior_sigma",1)));
                if (as_bool(logical_eq(lower_truncation,0))) {

                    lp_accum__.add(neg_binomial_2_log_log<propto__>(y_int, y_hat, get_base1(nb2_phi,1,"nb2_phi",1)));
                } else {

                    for (int i = 1; i <= N; ++i) {

                        lp_accum__.add(neg_binomial_2_log<propto__>(get_base1(y_int,i,"y_int",1), exp(get_base1(y_hat,i,"y_hat",1)), get_base1(nb2_phi,1,"nb2_phi",1)));
                        if (get_base1(y_int,i,"y_int",1) < lower_truncation) lp_accum__.add(-std::numeric_limits<double>::infinity());
                        else lp_accum__.add(-log_sum_exp(neg_binomial_2_ccdf_log(lower_truncation, exp(get_base1(y_hat,i,"y_hat",1)), get_base1(nb2_phi,1,"nb2_phi",1)), neg_binomial_2_log(lower_truncation, exp(get_base1(y_hat,i,"y_hat",1)), get_base1(nb2_phi,1,"nb2_phi",1))));
                    }
                }
            }
            if (as_bool(logical_eq(obs_model,4))) {

                lp_accum__.add(bernoulli_logit_log<propto__>(y_int, y_hat));
            }
            if (as_bool(logical_eq(obs_model,5))) {

                lp_accum__.add(poisson_log_log<propto__>(y_int, y_hat));
            }
            if (as_bool(logical_eq(obs_model,6))) {

                lp_accum__.add(student_t_log<propto__>(get_base1(sigma,1,"sigma",1), get_base1(prior_sigma,1,"prior_sigma",1), get_base1(prior_sigma,2,"prior_sigma",1), get_base1(prior_sigma,3,"prior_sigma",1)));
                lp_accum__.add(lognormal_log<propto__>(y, y_hat, get_base1(sigma,1,"sigma",1)));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gp_theta");
        names__.push_back("gp_sigma");
        names__.push_back("df");
        names__.push_back("sigma");
        names__.push_back("CV");
        names__.push_back("nb2_phi");
        names__.push_back("yearEffects");
        names__.push_back("year_sigma");
        names__.push_back("spatialEffectsKnots");
        names__.push_back("B");
        names__.push_back("phi");
        names__.push_back("W");
        names__.push_back("muZeros");
        names__.push_back("spatialEffects");
        names__.push_back("SigmaKnots");
        names__.push_back("transformed_dist");
        names__.push_back("transformed_dist21");
        names__.push_back("SigmaOffDiag");
        names__.push_back("invSigmaKnots");
        names__.push_back("y_hat");
        names__.push_back("gammaA");
        names__.push_back("gp_sigma_sq");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_df);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(norm_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(gamma_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nb2_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_year_effects);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_temporalRE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nT);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCov);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_phi);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nW);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nT);
        dims__.push_back(nLocs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(gamma_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_glmmfields_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double gp_theta = in__.scalar_lb_constrain(0);
        double gp_sigma = in__.scalar_lb_constrain(0);
        vector<double> df;
        size_t dim_df_0__ = est_df;
        for (size_t k_0__ = 0; k_0__ < dim_df_0__; ++k_0__) {
            df.push_back(in__.scalar_lb_constrain(df_lower_bound));
        }
        vector<double> sigma;
        size_t dim_sigma_0__ = norm_params;
        for (size_t k_0__ = 0; k_0__ < dim_sigma_0__; ++k_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> CV;
        size_t dim_CV_0__ = gamma_params;
        for (size_t k_0__ = 0; k_0__ < dim_CV_0__; ++k_0__) {
            CV.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> nb2_phi;
        size_t dim_nb2_phi_0__ = nb2_params;
        for (size_t k_0__ = 0; k_0__ < dim_nb2_phi_0__; ++k_0__) {
            nb2_phi.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> yearEffects;
        size_t dim_yearEffects_0__ = n_year_effects;
        for (size_t k_0__ = 0; k_0__ < dim_yearEffects_0__; ++k_0__) {
            yearEffects.push_back(in__.scalar_constrain());
        }
        vector<double> year_sigma;
        size_t dim_year_sigma_0__ = est_temporalRE;
        for (size_t k_0__ = 0; k_0__ < dim_year_sigma_0__; ++k_0__) {
            year_sigma.push_back(in__.scalar_lb_constrain(0));
        }
        vector<vector_d> spatialEffectsKnots;
        size_t dim_spatialEffectsKnots_0__ = nT;
        for (size_t k_0__ = 0; k_0__ < dim_spatialEffectsKnots_0__; ++k_0__) {
            spatialEffectsKnots.push_back(in__.vector_constrain(nKnots));
        }
        vector_d B = in__.vector_constrain(nCov);
        vector<double> phi;
        size_t dim_phi_0__ = est_phi;
        for (size_t k_0__ = 0; k_0__ < dim_phi_0__; ++k_0__) {
            phi.push_back(in__.scalar_lub_constrain(-(1),1));
        }
        vector<double> W;
        size_t dim_W_0__ = nW;
        for (size_t k_0__ = 0; k_0__ < dim_W_0__; ++k_0__) {
            W.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(gp_theta);
        vars__.push_back(gp_sigma);
            for (int k_0__ = 0; k_0__ < est_df; ++k_0__) {
            vars__.push_back(df[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < norm_params; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < gamma_params; ++k_0__) {
            vars__.push_back(CV[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nb2_params; ++k_0__) {
            vars__.push_back(nb2_phi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < n_year_effects; ++k_0__) {
            vars__.push_back(yearEffects[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < est_temporalRE; ++k_0__) {
            vars__.push_back(year_sigma[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nT; ++k_0__) {
                vars__.push_back(spatialEffectsKnots[k_0__][k_1__]);
                }
            }
            for (int k_0__ = 0; k_0__ < nCov; ++k_0__) {
            vars__.push_back(B[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < est_phi; ++k_0__) {
            vars__.push_back(phi[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < nW; ++k_0__) {
            vars__.push_back(W[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("muZeros", "nKnots", nKnots);
            vector_d muZeros(static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) muZeros;  // dummy to suppress unused var warning

            stan::math::initialize(muZeros, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(muZeros,DUMMY_VAR__);
            validate_non_negative_index("spatialEffects", "nLocs", nLocs);
            validate_non_negative_index("spatialEffects", "nT", nT);
            vector<vector_d> spatialEffects(nT, (vector_d(static_cast<Eigen::VectorXd::Index>(nLocs))));
            stan::math::initialize(spatialEffects, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(spatialEffects,DUMMY_VAR__);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            matrix_d SigmaKnots(static_cast<Eigen::VectorXd::Index>(nKnots),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) SigmaKnots;  // dummy to suppress unused var warning

            stan::math::initialize(SigmaKnots, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(SigmaKnots,DUMMY_VAR__);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            matrix_d transformed_dist(static_cast<Eigen::VectorXd::Index>(nKnots),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) transformed_dist;  // dummy to suppress unused var warning

            stan::math::initialize(transformed_dist, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(transformed_dist,DUMMY_VAR__);
            validate_non_negative_index("transformed_dist21", "nLocs", nLocs);
            validate_non_negative_index("transformed_dist21", "nKnots", nKnots);
            matrix_d transformed_dist21(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) transformed_dist21;  // dummy to suppress unused var warning

            stan::math::initialize(transformed_dist21, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(transformed_dist21,DUMMY_VAR__);
            validate_non_negative_index("SigmaOffDiag", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiag", "nKnots", nKnots);
            matrix_d SigmaOffDiag(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) SigmaOffDiag;  // dummy to suppress unused var warning

            stan::math::initialize(SigmaOffDiag, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(SigmaOffDiag,DUMMY_VAR__);
            validate_non_negative_index("invSigmaKnots", "nLocs", nLocs);
            validate_non_negative_index("invSigmaKnots", "nKnots", nKnots);
            matrix_d invSigmaKnots(static_cast<Eigen::VectorXd::Index>(nLocs),static_cast<Eigen::VectorXd::Index>(nKnots));
            (void) invSigmaKnots;  // dummy to suppress unused var warning

            stan::math::initialize(invSigmaKnots, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(invSigmaKnots,DUMMY_VAR__);
            validate_non_negative_index("y_hat", "N", N);
            vector_d y_hat(static_cast<Eigen::VectorXd::Index>(N));
            (void) y_hat;  // dummy to suppress unused var warning

            stan::math::initialize(y_hat, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(y_hat,DUMMY_VAR__);
            validate_non_negative_index("gammaA", "gamma_params", gamma_params);
            vector<double> gammaA(gamma_params, 0.0);
            stan::math::initialize(gammaA, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gammaA,DUMMY_VAR__);
            double gp_sigma_sq(0.0);
            (void) gp_sigma_sq;  // dummy to suppress unused var warning

            stan::math::initialize(gp_sigma_sq, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(gp_sigma_sq,DUMMY_VAR__);


            stan::math::assign(gp_sigma_sq, pow((gp_sigma * gp_sigma_scaling_factor),2.0));
            if (as_bool(logical_eq(cov_func,0))) {

                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq,exp(divide(minus(distKnots),gp_theta))));
                stan::math::assign(SigmaOffDiag, multiply(gp_sigma_sq,exp(divide(minus(distKnots21),gp_theta))));
            }
            if (as_bool(logical_eq(cov_func,1))) {

                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq,exp(multiply(-(inv((2.0 * pow(gp_theta,2.0)))),distKnots))));
                stan::math::assign(SigmaOffDiag, multiply(gp_sigma_sq,exp(multiply(-(inv((2.0 * pow(gp_theta,2.0)))),distKnots21))));
            }
            if (as_bool(logical_eq(cov_func,2))) {

                if (as_bool(logical_eq(matern_kappa,1.5))) {

                    stan::math::assign(transformed_dist, divide(multiply(sqrt(3.0),distKnots),gp_theta));
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq,add(1.0,transformed_dist)),exp(minus(transformed_dist))));
                    stan::math::assign(transformed_dist21, divide(multiply(sqrt(3.0),distKnots21),gp_theta));
                    stan::math::assign(SigmaOffDiag, elt_multiply(multiply(gp_sigma_sq,add(1.0,transformed_dist21)),exp(minus(transformed_dist21))));
                }
                if (as_bool(logical_eq(matern_kappa,2.5))) {

                    stan::math::assign(transformed_dist, divide(multiply(sqrt(5.0),distKnots),gp_theta));
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq,add(add(1.0,transformed_dist),divide(elt_multiply(transformed_dist,transformed_dist),3.0))),exp(minus(transformed_dist))));
                    stan::math::assign(transformed_dist21, divide(multiply(sqrt(5.0),distKnots21),gp_theta));
                    stan::math::assign(SigmaOffDiag, elt_multiply(multiply(gp_sigma_sq,add(add(1.0,transformed_dist21),divide(elt_multiply(transformed_dist21,transformed_dist21),3.0))),exp(minus(transformed_dist21))));
                }
            }
            for (int k = 1; k <= nKnots; ++k) {

                stan::math::assign(get_base1_lhs(muZeros,k,"muZeros",1), 0);
            }
            stan::math::assign(SigmaOffDiag, multiply(SigmaOffDiag,inverse_spd(SigmaKnots)));
            for (int t = 1; t <= nT; ++t) {

                stan::math::assign(get_base1_lhs(spatialEffects,t,"spatialEffects",1), multiply(SigmaOffDiag,get_base1(spatialEffectsKnots,t,"spatialEffectsKnots",1)));
            }
            for (int i = 1; i <= N; ++i) {

                if (as_bool(logical_eq(est_temporalRE,0))) {

                    if (as_bool(logical_eq(fixed_intercept,0))) {

                        stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), (multiply(get_base1(X,i,"X",1),B) + get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2)));
                    } else {

                        stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2));
                    }
                } else {

                    stan::math::assign(get_base1_lhs(y_hat,i,"y_hat",1), (get_base1(get_base1(spatialEffects,get_base1(yearID,i,"yearID",1),"spatialEffects",1),get_base1(stationID,i,"stationID",1),"spatialEffects",2) + get_base1(yearEffects,get_base1(yearID,i,"yearID",1),"yearEffects",1)));
                }
            }
            if (as_bool(logical_eq(obs_model,0))) {

                stan::math::assign(get_base1_lhs(gammaA,1,"gammaA",1), inv(pow(get_base1(CV,1,"CV",1),2.0)));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < gamma_params; ++k0__) {
                check_greater_or_equal(function__,"gammaA[k0__]",gammaA[k0__],0);
            }
            check_greater_or_equal(function__,"gp_sigma_sq",gp_sigma_sq,0);

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < nKnots; ++k_0__) {
            vars__.push_back(muZeros[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < nLocs; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nT; ++k_0__) {
                vars__.push_back(spatialEffects[k_0__][k_1__]);
                }
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nKnots; ++k_0__) {
                vars__.push_back(SigmaKnots(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nKnots; ++k_0__) {
                vars__.push_back(transformed_dist(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nLocs; ++k_0__) {
                vars__.push_back(transformed_dist21(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nLocs; ++k_0__) {
                vars__.push_back(SigmaOffDiag(k_0__, k_1__));
                }
            }
            for (int k_1__ = 0; k_1__ < nKnots; ++k_1__) {
                for (int k_0__ = 0; k_0__ < nLocs; ++k_0__) {
                vars__.push_back(invSigmaKnots(k_0__, k_1__));
                }
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(y_hat[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < gamma_params; ++k_0__) {
            vars__.push_back(gammaA[k_0__]);
            }
        vars__.push_back(gp_sigma_sq);

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "N", N);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(N));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int i = 1; i <= N; ++i) {

                if (as_bool(logical_eq(obs_model,0))) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), gamma_log(get_base1(y,i,"y",1),get_base1(gammaA,1,"gammaA",1),(get_base1(gammaA,1,"gammaA",1) / exp(get_base1(y_hat,i,"y_hat",1)))));
                }
                if (as_bool(logical_eq(obs_model,1))) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(y,i,"y",1),get_base1(y_hat,i,"y_hat",1),get_base1(sigma,1,"sigma",1)));
                }
                if (as_bool(logical_eq(obs_model,2))) {

                    if (as_bool(logical_eq(lower_truncation,0))) {

                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), neg_binomial_2_log_log(get_base1(y_int,i,"y_int",1),get_base1(y_hat,i,"y_hat",1),get_base1(nb2_phi,1,"nb2_phi",1)));
                    } else {

                        stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), neg_binomial_2_log(get_base1(y_int,i,"y_int",1),exp(get_base1(y_hat,i,"y_hat",1)),get_base1(nb2_phi,1,"nb2_phi",1)));
                    }
                }
                if (as_bool(logical_eq(obs_model,4))) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), bernoulli_logit_log(get_base1(y_int,i,"y_int",1),get_base1(y_hat,i,"y_hat",1)));
                }
                if (as_bool(logical_eq(obs_model,5))) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), poisson_log_log(get_base1(y_int,i,"y_int",1),get_base1(y_hat,i,"y_hat",1)));
                }
                if (as_bool(logical_eq(obs_model,6))) {

                    stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), lognormal_log(get_base1(y,i,"y",1),y_hat,get_base1(sigma,1,"sigma",1)));
                }
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_glmmfields";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= est_df; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "df" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= norm_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= gamma_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "CV" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nb2_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_year_effects; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yearEffects" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= est_temporalRE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "year_sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nT; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffectsKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nCov; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= est_phi; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nW; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "W" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "muZeros" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= nLocs; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nT; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffects" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "transformed_dist" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "transformed_dist21" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaOffDiag" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "invSigmaKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_hat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= gamma_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gammaA" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma_sq";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= est_df; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "df" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= norm_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= gamma_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "CV" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nb2_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= n_year_effects; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yearEffects" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= est_temporalRE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "year_sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nT; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffectsKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= nCov; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= est_phi; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= nW; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "W" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "muZeros" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= nLocs; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nT; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffects" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nKnots; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "transformed_dist" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "transformed_dist21" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "SigmaOffDiag" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_1__ = 1; k_1__ <= nKnots; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= nLocs; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "invSigmaKnots" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "y_hat" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= gamma_params; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gammaA" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma_sq";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




#endif
