% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_covstruct.R
\name{numFactor}
\alias{numFactor}
\alias{parseNumLevels}
\title{Factor with numeric interpretable levels.}
\usage{
numFactor(x, ...)

parseNumLevels(levels)
}
\arguments{
\item{x}{Vector, matrix or data.frame that constitute the
coordinates.}

\item{...}{Additional vectors, matrices or data.frames that
constitute the coordinates.}

\item{levels}{Character vector to parse into numeric values.}
}
\value{
Factor with specialized coding of levels.
}
\description{
Create a factor with numeric interpretable factor levels.
}
\details{
Some \code{glmmTMB} covariance structures require extra
information, such as temporal or spatial
coordinates. \code{numFactor} allows to associate such extra
information as part of a factor via the factor levels. The
original numeric coordinates are recoverable without loss of
precision using the function \code{parseNumLevels}.  Factor levels
are sorted coordinate wise from left to right: first coordinate is
fastest running.
}
\examples{
## 1D example
numFactor(sample(1:5,20,TRUE))
## 2D example
coords <- cbind( sample(1:5,20,TRUE), sample(1:5,20,TRUE) )
(f <- numFactor(coords))
parseNumLevels(levels(f)) ## Sorted
## Used as part of a model.matrix
model.matrix( ~f )
## parseNumLevels( colnames(model.matrix( ~f )) )
## Error: 'Failed to parse numeric levels: (Intercept)'
parseNumLevels( colnames(model.matrix( ~ f-1 )) )
}

