% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{df_for_wald}
\alias{df_for_wald}
\alias{df_for_wald.glm}
\alias{df_for_wald.default}
\title{Gets the degree of freedom for Wald tests involving the model}
\usage{
df_for_wald(object, ...)

\method{df_for_wald}{glm}(object, ...)

\method{df_for_wald}{default}(object, ...)
}
\arguments{
\item{object}{statistical model;}

\item{...}{Unused by \code{p_value_contrast.default}, but may be useful to some custom specializations.}
}
\value{
A finite value or Inf for normal distribution approximation.
}
\description{
This generic function is used by \code{\link{p_value_contrast.default}} to
get the number of degrees of freedom of the \link[stats:TDist]{t distribution} that
approximates the point estimate of the contrast divided by its standard error.
}
\details{
This function is quite similar to \code{\link[stats:df.residual]{df.residual}} but it should return Inf when the Student's t
distribution is less appropriate than the normal distribution.
}
\section{Methods (by class)}{
\itemize{
\item \code{glm}: Returns \code{\link[stats:df.residual]{df.residual}} for linear gaussian models and Inf
for all other models in order to make Wald's tests consistent with the behavior of \code{\link[stats:summary.glm]{stats::summary.glm(object)}}

\item \code{default}: Simple proxy to \code{\link[stats:df.residual]{df.residual}} but replaces NAs with Inf
}}

\examples{
# 10 observations, one coefficient, 9 degrees of freedom
df_for_wald(glm(I(1:10) ~ 1))
# returns Inf (non-gaussian-identity model)
df_for_wald(glm(family="poisson", c(10,20,30) ~ 1))
data(mtcars)
# returns Inf (non-gaussian-identity model)
df_for_wald(glm(family="binomial", data=mtcars, I(hp > median(hp)) ~ cyl))
}
\seealso{
Other Wald-related functions: 
\code{\link{fixcoef}()},
\code{\link{p_value_contrast}()},
\code{\link{vcov_fixcoef}()}
}
\concept{Wald-related functions}
