% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_discrete_vars.R
\name{plot_discrete_vars}
\alias{plot_discrete_vars}
\title{Plot Discrete Variables}
\usage{
plot_discrete_vars(x, nvalues = 15, sort_by_frequency = FALSE)
}
\arguments{
\item{x}{Data frame, tibble or matrix with data.}

\item{nvalues}{Integer. It creates a bar plot for each variable
with at most this amount of different values. The default
value is 15.}

\item{sort_by_frequency}{Logical. It casts every variable to
factor and then reorders the levels by frequency before
generating the plot.}
}
\value{
A GGplot object.
}
\description{
Creates a grid of bar plots for variables with at most
\code{nvalues} (15 is the default) different values.
}
\examples{
library(glancedata)

plot_discrete_vars(mtcars)
plot_discrete_vars(mtcars, sort_by_frequency = TRUE)
plot_discrete_vars(iris)

## The following two examples give a warning because they don't
## have any variable with fewer than 15 different values.
plot_discrete_vars(cars)
plot_discrete_vars(state.x77)
}
\author{
Guillermo Basulto-Elias
}
