% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-inference.R
\name{logLik.gkwreg}
\alias{logLik.gkwreg}
\title{Extract Log-Likelihood from Generalized Kumaraswamy Regression Models}
\usage{
\method{logLik}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{...}{Currently not used.}
}
\value{
An object of class \code{"logLik"} containing the log-likelihood value
with the following attributes:
\describe{
\item{\code{df}}{Number of estimated parameters}
\item{\code{nobs}}{Number of observations}
}
}
\description{
Extracts the log-likelihood value from a fitted Generalized Kumaraswamy (GKw)
regression model object.
}
\details{
The log-likelihood is extracted from the fitted model object and returned as
an object of class \code{"logLik"} with appropriate attributes for the number
of parameters (\code{df}) and observations (\code{nobs}). These attributes
are required for information criteria calculations.

For a GKw regression model with parameter vector \eqn{\theta}, the log-likelihood
is defined as:
\deqn{\ell(\theta \mid y) = \sum_{i=1}^n \log f(y_i; \alpha_i, \beta_i, \gamma_i, \delta_i, \lambda_i)}
where \eqn{f(\cdot)} is the probability density function of the specified GKw
family distribution, and the parameters may depend on covariates through link
functions.
}
\examples{
\donttest{
# Load example data
data(GasolineYield)

# Fit a Kumaraswamy regression model
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")

# Extract log-likelihood
ll <- logLik(fit)
print(ll)

# Access attributes
cat("Log-likelihood:", as.numeric(ll), "\n")
cat("Parameters:", attr(ll, "df"), "\n")
cat("Observations:", attr(ll, "nobs"), "\n")
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{AIC.gkwreg}}, \code{\link{BIC.gkwreg}}
}
\author{
Lopes, J. E.
}
