% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{.check_and_compile_TMB_code}
\alias{.check_and_compile_TMB_code}
\title{Check and Compile TMB Model Code with Persistent Cache}
\usage{
.check_and_compile_TMB_code(
  dll_name,
  pkg_name = "gkwreg",
  force_recompile = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{dll_name}{A character string specifying the base name of the C++ file
and the resulting DLL. The function assumes the code file is \code{dll_name.cpp}
located in the \code{inst/tmb/} directory of the package.}

\item{pkg_name}{A character string specifying the package name. Defaults to "gkwreg".}

\item{force_recompile}{Logical; if \code{TRUE}, forces recompilation even if
a valid compiled file exists (default is \code{FALSE}).}

\item{verbose}{Logical; if \code{TRUE}, prints detailed status messages
(default is \code{TRUE}).}
}
\value{
Returns (invisibly) a list with information about the compiled model, including path,
normalized path, name, and compilation status.
If any step fails, an error is thrown.
}
\description{
This utility function verifies whether the TMB model shared object (\code{.so/.dll}) file
has already been compiled for a specified DLL name. If not, it compiles the
corresponding C++ file and caches it in a persistent directory across R sessions.
}
\details{
The function works through the following steps:
\enumerate{
\item Creates a persistent cache directory for storing compiled TMB models.
\item Checks if a compiled file for the specified DLL already exists in the
cache directory and whether it's up-to-date compared to the source code.
\item If a valid compiled file exists, it loads it directly.
\item If not, the function locates the corresponding C++ file inside the
package, compiles it, and stores the result in the cache directory.
\item Provides diagnostic messages regarding compilation status and exported symbols.
}
}
\keyword{internal}
