% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.r
\name{gitter}
\alias{gitter}
\title{Process a single plate image}
\usage{
gitter(image.file = file.choose(), plate.format = c(32, 48),
  remove.noise = F, autorotate = F, inverse = F, verbose = "l",
  contrast = NULL, fast = NULL, plot = F, grid.save = getwd(),
  dat.save = getwd(), .is.ref = F, .params = NULL)
}
\arguments{
\item{image.file}{The path to the image. Defaults to a file choosing dialog.}

\item{plate.format}{The plate format, accepted formats: 1536, 768, 384 and 96. Alternatively, you can provide the number of rows and columns on the plate as an integer vector for example c(32,48). Default is 1536.}

\item{remove.noise}{Logical indicating noise/speckles should be remove from the thresholded image prior to analysis. Default is \code{FALSE}.}

\item{autorotate}{Logical indicating if image should be auto-rotated prior to processing. Only select this option if image is extremely rotated. gitter is able to handle small variations in rotations (1-2 degrees) without auto-rotating. Default is \code{FALSE}.}

\item{inverse}{Logical indicating if input image is inverted, meaning colonies are darker compared to their background. Default is \code{FALSE}.}

\item{verbose}{Shows details about the results of running job. For detailed logs "l", for a progress bar "p" or for no output "n". Default is "l".}

\item{contrast}{Integer between 1 and 100 indicating how much contrast should be applied to the image, prior to processing. A value of \code{NULL} will not apply any contrast. Default is \code{NULL}.}

\item{fast}{If set to integer value, the image will be resized to this width in pixels to speed up computation. This is useful for very large images that otherwise take a long time to process. We do not recommend resizing to fewer than 1500 pixels or greater that 4000 pixels in width. Default is \code{NULL}.}

\item{plot}{Logical indicating whether intensity profiles should be plotted. Default is \code{FALSE}.}

\item{grid.save}{Directory path to save gridded/thresholded images. Set to \code{NULL} if you do not want gridded images saved to disk. Default is the current working directory.}

\item{dat.save}{Directory path to save resulting data files. Set to \code{NULL} if you do not want resulting data saved to disk. Default is the current working directory.}

\item{.is.ref}{Specifies if a reference property list is supplied. Warning: NOT for use by casual users.}

\item{.params}{Reference property list. Warning: NOT for use by casual users.}
}
\value{
\item{ DAT file }{
  Tab delimited file containing quantified colony sizes. There are two types of flags that can be associated with a data file
  (1) plate-level flags signify possible misgridding of the plate due to a high number of colonies with small size or low circularity. #' These flags can be viewed using the \code{\link{plate.warnings}} function
  (2) colony-based flags signify warnings associated with individual colonies. These flags can be viewed in the column named flags of #' the data file.
  \tabular{ll}{
    row: \tab row number\cr
    col: \tab column number\cr
    size: \tab quantified colony size\cr
    circularity: \tab circularity of the colony\cr
    flags: \tab colony-based flags: S - Colony spill or edge interference, C- Low colony circularity\cr
  }
}

\item{ Gridded image }{Thresholded image showing the grid defined over the image}
}
\description{
The following function will grid and quantify a single plate image (for batch processing, see \code{\link{gitter.batch}})
}
\examples{
# Read sample image
f = system.file("extdata", "sample.jpg", package="gitter")
# Process it
dat = gitter(f)
# View head of the results
head(dat)
}
\keyword{gitter}
\keyword{image}
\keyword{process}
\keyword{sga}
\keyword{single}

