% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/stash.r
\docType{methods}
\name{summary,git_stash-method}
\alias{summary,git_stash-method}
\alias{summary,git_stash-methods}
\title{Summary of a stash}
\usage{
\S4method{summary}{git_stash}(object, ...)
}
\arguments{
\item{object}{The stash \code{object}}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
None (invisible 'NULL').
}
\description{
Summary of a stash
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

# Configure a user
config(repo, user.name="Alice", user.email="alice@example.org")

# Create a file, add and commit
writeLines("Hello world!", file.path(path, "test.txt"))
add(repo, 'test.txt')
commit(repo, "Commit message")

# Change file
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "test.txt"))

# Create stash in repository
stash(repo, "Stash message")

# View summary of stash
summary(stash_list(repo)[[1]])
}
}
\keyword{methods}

