% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/when.r
\docType{methods}
\name{when}
\alias{when}
\alias{when,git_commit-method}
\alias{when,git_signature-method}
\alias{when,git_stash-method}
\alias{when,git_tag-method}
\alias{when,git_time-method}
\title{When}
\usage{
when(object)

\S4method{when}{git_commit}(object)

\S4method{when}{git_signature}(object)

\S4method{when}{git_stash}(object)

\S4method{when}{git_tag}(object)

\S4method{when}{git_time}(object)
}
\arguments{
\item{object}{the \code{object} to extract the time slot from.}
}
\value{
A \code{character} vector of length one.
}
\description{
Help method to extract the time as a character string from the S4
classes \code{git_commit}, \code{git_signature}, \code{git_tag}
and \code{git_time}.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a first user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

when(commits(repo)[[1]])
when(tags(repo)[[1]])
}
}
\keyword{methods}

