% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset.r
\docType{methods}
\name{reset}
\alias{reset}
\alias{reset,git_commit-method}
\title{Reset current HEAD to the specified state}
\usage{
reset(commit, reset_type = c("soft", "mixed", "hard"))

\S4method{reset}{git_commit}(commit, reset_type = c("soft", "mixed", "hard"))
}
\arguments{
\item{commit}{The \code{\linkS4class{git_commit}} to which the
HEAD should be moved to.}

\item{reset_type}{Kind of reset operation to perform. 'soft' means
the Head will be moved to the commit. 'mixed' reset will trigger a
'soft' reset, plus the index will be replaced with the content of
the commit tree. 'hard' reset will trigger a 'mixed' reset and the
working directory will be replaced with the content of the index.}
}
\value{
invisible NULL
}
\description{
Reset current HEAD to the specified state
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

# Configure a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Hello world!", file.path(path, "test-1.txt"))
add(repo, 'test-1.txt')
commit_1 <- commit(repo, "Commit message")

## Make one more commit
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "test-1.txt"))
add(repo, 'test-1.txt')
commit(repo, "Next commit message")

## Create one more file
writeLines("Hello world!", file.path(path, "test-2.txt"))

## 'soft' reset to first commit and check status
reset(commit_1)
status(repo)

## 'mixed' reset to first commit and check status
commit(repo, "Next commit message")
reset(commit_1, "mixed")
status(repo)

## 'hard' reset to first commit and check status
add(repo, 'test-1.txt')
commit(repo, "Next commit message")
reset(commit_1, "hard")
status(repo)
}
}
\keyword{methods}

