% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{branch_get_upstream}
\alias{branch_get_upstream}
\alias{branch_get_upstream,git_branch-method}
\title{Get remote tracking branch}
\usage{
branch_get_upstream(branch)

\S4method{branch_get_upstream}{git_branch}(branch)
}
\arguments{
\item{branch}{The branch}
}
\value{
S4 class git_branch or NULL if no remote tracking branch.
}
\description{
Get remote tracking branch, given a local branch.
}
\examples{
\dontrun{
## Initialize two temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)
repo <- clone(path_bare, path_repo)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
## Adds an upstream tracking branch to branch 'master'
push(repo, "origin", "refs/heads/master")

## Get remote tracking branch
branch_get_upstream(head(repo))
}
}
\keyword{methods}

