% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkout.r
\docType{methods}
\name{checkout}
\alias{checkout}
\alias{checkout,git_branch-method}
\alias{checkout,git_commit-method}
\alias{checkout,git_repository-method}
\alias{checkout,git_tag-method}
\title{Checkout}
\usage{
checkout(object, ...)

\S4method{checkout}{git_repository}(object, branch, create = FALSE,
  force = FALSE)

\S4method{checkout}{git_branch}(object, force = FALSE)

\S4method{checkout}{git_commit}(object, force = FALSE)

\S4method{checkout}{git_tag}(object, force = FALSE)
}
\arguments{
\item{object}{A repository, commit, tag or tree which content will
be used to update the working directory.}

\item{...}{Additional arguments affecting the checkout}

\item{branch}{If object is a repository, the name of the branch to
check out.}

\item{create}{If object is a repository, then branch is created if
doesn't exist.}

\item{force}{If TRUE, then make working directory match
target. This will throw away local changes. Default is FALSE.}
}
\value{
invisible NULL
}
\description{
Update files in the index and working tree to match the content of
the tree pointed at by the treeish object (commit, tag or tree).
Checkout using the default GIT_CHECKOUT_SAFE_CREATE strategy
(force = FALSE) or GIT_CHECKOUT_FORCE (force = TRUE).
}
\examples{
\dontrun{
## Create directories and initialize repositories
path_bare <- tempfile(pattern="git2r-")
path_repo_1 <- tempfile(pattern="git2r-")
path_repo_2 <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo_1)
dir.create(path_repo_2)
repo_bare <- init(path_bare, bare = TRUE)

## Clone to repo 1 and config user
repo_1 <- clone(path_bare, path_repo_1)
config(repo_1, user.name="Alice", user.email="alice@example.org")

## Add changes to repo 1 and push to bare
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path_repo_1, "test.txt"))
add(repo_1, "test.txt")
commit(repo_1, "First commit message")
push(repo_1, "origin", "refs/heads/master")

## Create and checkout 'dev' branch in repo 1
checkout(repo_1, "dev", create = TRUE)

## Add changes to 'dev' branch in repo 1 and push to bare
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           con = file.path(path_repo_1, "test.txt"))
add(repo_1, "test.txt")
commit(repo_1, "Second commit message")
push(repo_1, "origin", "refs/heads/dev")

## Clone to repo 2
repo_2 <- clone(path_bare, path_repo_2)
config(repo_2, user.name="Bob", user.email="bob@example.org")

## Read content of 'test.txt'
readLines(file.path(path_repo_2, "test.txt"))

## Checkout dev branch
checkout(repo_2, "dev")

## Read content of 'test.txt'
readLines(file.path(path_repo_2, "test.txt"))
}
}
\keyword{methods}

