% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gist.R
\name{gist}
\alias{as.gist}
\alias{gist}
\title{Get a gist}
\usage{
gist(id, ...)

as.gist(x)
}
\arguments{
\item{id}{(character) A gist id}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{x}{Object to coerce. Can be an integer (gist id), string
(gist id), a gist, or an list that can be coerced to a gist.}
}
\description{
Get a gist
}
\details{
If a file is larger than ~1 MB, the content of the file given back
is truncated, so you won't get the entire contents. In the return S3 object
that's printed, we tell you at the bottom whether each file is truncated or
not. If a file is, simply get the \code{raw_url} URL for the file (see
example below), then retrieve from that. If the file is very big, you may
need to clone the file using git, etc.
}
\examples{
\dontrun{
gist(id = 'f1403260eb92f5dfa7e1')

as.gist('f1403260eb92f5dfa7e1')
as.gist(10)
as.gist(gist('f1403260eb92f5dfa7e1'))

ids <- sapply(gists(), "[[", "id")
gist(ids[1])
gist(ids[2])
gist(ids[3])
gist(ids[4])

gist(ids[1]) \%>\% browse()

## If a gist file is > a certain size it is truncated
## in this case, we let you know in the return object that it is truncated
## e.g.
(bigfile <- gist(id = "b74b878fd7d9176a4c52"))
## then get the raw_url, and retrieve the file
url <- bigfile$files$`plossmall.json`$raw_url
# httr::GET(url)
}
}

