% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifti_list.R
\name{gifti_list}
\alias{gifti_list}
\title{Convert GIFTI to List}
\usage{
gifti_list(file)
}
\arguments{
\item{file}{file name of GIFTI file}
}
\value{
List of elements
}
\description{
Reads in a GIFTI file and coerces it to a list
}
\examples{
if (have_gifti_test_data()) {
   gii_files = download_gifti_data()
   L = gifti_list(gii_files[1])
   orig = L$DataArray$Data[[1]]
   encoding = attributes(L$DataArray)$Encoding
   datatype = attributes(L$DataArray)$DataType
   endian = attributes(L$DataArray)$Endian
   vals =  data_decoder(orig, encoding = encoding,
   datatype = datatype, endian = endian)
   enc = data_encoder(vals, encoding = encoding,
   datatype = datatype, endian = endian)
   enc == orig
}
}
