% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwordcloud-wrapper.R
\name{ggwordcloud}
\alias{ggwordcloud}
\title{wordcloud approximate replacement}
\usage{
ggwordcloud(words, freq, scale = c(4, 0.5), min.freq = 3,
  max.words = Inf, random.order = TRUE, random.color = FALSE,
  rot.per = 0.1, colors = "black", ordered.colors = FALSE, ...)
}
\arguments{
\item{words}{the words}

\item{freq}{their frequencies}

\item{scale}{A vector of length 2 indicating the range of the size of the
words.}

\item{min.freq}{words with frequency below min.freq will not be plotted}

\item{max.words}{Maximum number of words to be plotted. least frequent terms
dropped}

\item{random.order}{plot words in random order. If false, they will be
plotted in decreasing frequency}

\item{random.color}{choose colors randomly from the colors. If false, the
color is chosen based on the frequency}

\item{rot.per}{proportion words with 90 degree rotation}

\item{colors}{color words from least to most frequent}

\item{ordered.colors}{if true, then colors are assigned to words in order}

\item{...}{Additional parameters to be passed to geom_text_wordcloud}
}
\value{
a ggplot
}
\description{
\code{ggwordcloud} is meant as an approximate replacement for
\code{\link[wordcloud]{wordcloud}}. It has almost the same syntax but allows
only the words/freqs input. As the underlying algorithms are not strictly
equal, the resulting wordcloud is only similar to the ones one can obtain
with \code{\link[wordcloud]{wordcloud}}.
}
\examples{
set.seed(42)
data("love_words_small")

ggwordcloud(love_words_small$word, love_words_small$speakers)
}
