% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/few.R
\name{few_pal}
\alias{few_pal}
\title{Color Palettes Few "Show Me the Numbers"}
\usage{
few_pal(palette = "Medium")
}
\arguments{
\item{palette}{One of \Sexpr[results=rd,stage=build]{names(ggthemes:::rd_optlist(ggthemes::ggthemes_data$few$colors))}}
}
\description{
Qualitative color palettes from Stephen Few (2012)
\emph{Show Me the Numbers}. There are three palettes:
Light, Medium, and Dark. Each palette comprises nine colors:
gray, blue, orange, green, pink, brown, purple, yellow, red.
For \code{n = 1}, gray is used. For \code{n > 1}, the eight non-gray
colors are used.
}
\details{
Use the light palette for filled areas, such as bar charts.
Use the medium palette for points and lines.
Use the dark palette for highlighting specific points
or for small and thin lines and points.
}
\examples{
library("scales")

show_col(few_pal()(7))
show_col(few_pal("Dark")(7))
show_col(few_pal("Light")(7))
}
\references{
Few, S. (2012) \emph{Show Me the Numbers: Designing Tables and Graphs to Enlighten}.
2nd edition. Analytics Press.

\href{https://www.perceptualedge.com/articles/visual_business_intelligence/rules_for_using_color.pdf}{"Practical Rules for Using Color in Charts"}.
}
\seealso{
Other colour few: 
\code{\link{scale_colour_few}()}
}
\concept{colour few}
