% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc.R
\name{theme_hc}
\alias{theme_hc}
\title{Highcharts JS theme}
\usage{
theme_hc(base_size = 12, base_family = "sans", bgcolor = "default")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{bgcolor}{The background color of plot. One of \code{'default',
'darkunica'}, the names of values in
\code{ggthemes_data$hc$bg}.}
}
\description{
Theme based on the plots in \emph{Highcharts JS}.
}
\examples{


library("ggplot2")
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour=factor(gear))) + facet_wrap(~am)
p + theme_hc() + scale_colour_hc()
p + theme_hc(bgcolor = 'darkunica') + scale_colour_hc('darkunica')



}
\references{
\url{http://www.highcharts.com/demo/line-basic}

\url{https://github.com/highslide-software/highcharts.com/tree/master/js/themes}
}
