% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-tufteboxplot.R
\docType{data}
\name{geom_tufteboxplot}
\alias{GeomTufteboxplot}
\alias{geom_tufteboxplot}
\title{Tufte's Box Blot}
\usage{
geom_tufteboxplot(mapping = NULL, data = NULL, stat = "fivenumber",
  position = "identity", outlier.colour = "black", outlier.shape = 19,
  outlier.size = 1.5, outlier.stroke = 0.5, voffset = 0.01,
  hoffset = 0.005, na.rm = FALSE, show.legend = NA, inherit.aes = TRUE,
  median.type = "point", whisker.type = "line", ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{outlier.colour}{colour for outlying points}

\item{outlier.shape}{shape of outlying points}

\item{outlier.size}{size of outlying points}

\item{outlier.stroke}{stroke for outlying points}

\item{voffset}{controls the size of the gap in the line representing the median when \code{median.type = 'line'}. This is a fraction of the range of \code{y}.}

\item{hoffset}{controls how much the interquartile line is offset from the whiskers when \code{median.type = 'line'}. This is a fraction of the range of \code{x}.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{median.type}{If \code{'point'}, then the median is represented by a point, and the interquartile range by a gap in the line. If \code{median.type='line'}, then the interquartile range is represnted by a line, possibly offset, and the median by a gap in the line.}

\item{whisker.type}{If \code{'line'}, then whiskers are represented by lines. If \code{'point'}, then whiskers are represented by points at \code{ymin} and \code{ymax}.}

\item{...}{other arguments passed on to \code{\link{layer}}. There are
  three types of arguments you can use here:

  \itemize{
  \item Aesthetics: to set an aesthetic to a fixed value, like
     \code{color = "red"} or \code{size = 3}.
  \item Other arguments to the layer, for example you override the
    default \code{stat} associated with the layer.
  \item Other arguments passed on to the stat.
  }}
}
\description{
Edward Tufte's revisions of the box plot as described in
\emph{The Visual Display of Quantitative Information}.
}
\section{Aesthetics}{

\itemize{
\item x [required]
\item y [required]
\item colour
\item size
\item linetype
\item shape
\item fill
\item alpha
}
}
\examples{
library("ggplot2")
p <- ggplot(mtcars, aes(factor(cyl), mpg))
## with a point for the median and lines for whiskers
p + geom_tufteboxplot()
## with a line for the interquartile range and points for whiskers
p + geom_tufteboxplot(median.type = "line", whisker.type = "point", hoffset = 0)
## with a wide line for the interquartile range and lines for whiskers
p + geom_tufteboxplot(median.type = "line", hoffset = 0, width = 3)
## with an offset line for the interquartile range and lines for whiskers
p + geom_tufteboxplot(median.type='line')

}
\references{
Tufte, Edward R. (2001) The Visual Display of
Quantitative Information, Chapter 6.

McGill, R., Tukey, J. W. and Larsen, W. A. (1978) Variations of
    box plots. The American Statistician 32, 12-16.
}
\seealso{
\code{\link{geom_boxplot}}

Other geom tufte: \code{\link{geom_rangeframe}}
}
\keyword{datasets}

